/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.constant.enums;

import java.util.Locale;

public enum AiJudgmentTypeEnum {
    PRESENCE(1, "\u5b58\u5728\u5224\u65ad", "Presence judgment"),
    DURATION(2, "\u4efb\u52a1\u7f16\u8f91", "Duration judgment"),
    QUANTITY(3, "\u4efb\u52a1\u5f00\u542f", "Quantity judgment");

    private final Integer type;
    private final String nameZH;
    private final String nameEN;

    private AiJudgmentTypeEnum(Integer type, String nameZH, String nameEN) {
        this.type = type;
        this.nameZH = nameZH;
        this.nameEN = nameEN;
    }

    public static String getName(Integer type, String language) {
        for (AiJudgmentTypeEnum value : AiJudgmentTypeEnum.values()) {
            if (!value.getType().equals(type)) continue;
            if (Locale.ENGLISH.getLanguage().equals(language)) {
                return value.getNameEN();
            }
            return value.getNameZH();
        }
        return "";
    }

    public Integer getType() {
        return this.type;
    }

    public String getNameZH() {
        return this.nameZH;
    }

    public String getNameEN() {
        return this.nameEN;
    }
}

