/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.feign;

import com.ovopark.aicheck.model.organize.OrgRole;
import com.ovopark.aicheck.model.organize.UserRolePojo;
import com.ovopark.aicheck.model.organize.UsersPojo;
import com.ovopark.aicheck.result.BaseResult;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="ovopark-privilege")
public interface PrivilegeApi {
    @GetMapping(value={"/ovopark-privilege/user/getUsersById"})
    public BaseResult<UsersPojo> getUserById(@RequestParam(value="userId") Integer var1);

    @GetMapping(value={"/ovopark-privilege/role/getRolePojoById"})
    public BaseResult<OrgRole> getRolePojoById(@RequestParam(value="roleId") Integer var1);

    @GetMapping(value={"/ovopark-privilege/user/isSuperAdmin"})
    public BaseResult<Boolean> isSuperAdmin(@RequestParam(value="userId") Integer var1, @RequestParam(value="groupId") Integer var2);

    @PostMapping(value={"/ovopark-privilege/user/getUsersListPostByIds"})
    public BaseResult<List<UsersPojo>> batchGetUsers(@RequestBody List<Integer> var1);

    @PostMapping(value={"/ovopark-privilege/role/batchGetUserRoleList"})
    public BaseResult<Map<String, List<UserRolePojo>>> batchGetUserRoleMapList(@RequestBody List<Integer> var1);

    @GetMapping(value={"/ovopark-privilege/user/getUserByRoleIds"})
    public BaseResult<List<UsersPojo>> getUserByRoleIds(@RequestParam(value="roleIds") String var1, @RequestParam(value="groupId") Integer var2);

    @PostMapping(value={"/ovopark-privilege/feign/user/getUsersByDepIdAndRoleId"})
    public BaseResult<List<UsersPojo>> getUsersByDepIdAndRoleId(@RequestBody Map<String, Object> var1);

    @GetMapping(value={"ovopark-privilege/feign/privilege /hasPrivileges"})
    public BaseResult<Boolean> hasPrivileges(@RequestParam(value="UserId") Integer var1, @RequestParam(value="groupId") Integer var2, @RequestParam(value="privilege") String var3);
}

