/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.aicheck.model.job.XxlJobInfoBo;
import com.ovopark.aicheck.properties.XxlJobProperties;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XxlJobUtils {
    private static final Logger log = LoggerFactory.getLogger(XxlJobUtils.class);
    private static String address;
    private static Integer executorId;
    @Resource
    private XxlJobProperties xxlJobProperties;

    @PostConstruct
    public void init() {
        address = this.xxlJobProperties.getAddress();
        executorId = this.xxlJobProperties.getExecutor().getId();
    }

    public static Integer addJob(XxlJobInfoBo job) {
        job.setJobGroup(executorId);
        String json = JSONUtil.toJsonStr((Object)job);
        log.info("----------addJob param :----------: {}", (Object)json);
        String result = HttpRequest.post((String)(address + "/jobinfo/addByShopwebSupport")).body(json).execute().body();
        log.info("----------addJob result----------: {}", (Object)result);
        JSONObject childParam = JSONObject.parseObject((String)result);
        if (result == null || childParam.get("content") != null) {
            Integer jobId = Integer.parseInt(childParam.get("content").toString());
            return jobId;
        }
        return null;
    }

    public static void removeJob(Integer id) {
        log.info("----------removeJob param----------: {}", (Object)id);
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("id", id);
        String result = HttpRequest.post((String)(address + "/jobinfo/removeByShopwebSupport")).form(param).execute().body();
        log.info("----------removeJob result----------: {}", (Object)result);
    }

    public static void stopJob(Integer id) {
        log.info("----------stopJob param----------: {}", (Object)id);
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("id", id);
        String result = HttpRequest.post((String)(address + "/jobinfo/stopByShopwebSupport")).body(JSONUtil.toJsonStr(param)).execute().body();
        log.info("----------stopJob result----------: {}", (Object)result);
    }

    public static void startJob(Integer id) {
        log.info("----------startJob param----------: {}", (Object)id);
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("id", id);
        String result = HttpRequest.post((String)(address + "/jobinfo/startByShopwebSupport")).form(param).execute().body();
        log.info("----------startJob result----------: {}", (Object)result);
    }

    public static void updateJob(XxlJobInfoBo job) {
        log.info("----------updateJobInfo param :----------: {}", (Object)JSON.toJSONString((Object)job));
        String result = HttpRequest.post((String)(address + "/jobinfo/updateByShopwebSupport")).body(JSONUtil.toJsonStr((Object)job)).execute().body();
        log.info("----------updateJobInfo result----------: {}", (Object)result);
    }

    public static Integer creatSpecifiedJobTask(String executorHandler, String cron, String executorParamJson, String jobDesc) {
        XxlJobInfoBo job = new XxlJobInfoBo();
        job.setExecutorHandler(executorHandler);
        job.setJobCron(cron);
        job.setJobGroup(executorId);
        job.setAuthor("AI_System");
        job.setExecutorParam(executorParamJson);
        job.setJobDesc(jobDesc);
        job.setExecutorRouteStrategy("ROUND");
        job.setGlueType("BEAN");
        job.setExecutorBlockStrategy("SERIAL_EXECUTION");
        job.setExecutorTimeout(0);
        job.setExecutorFailRetryCount(1);
        Integer jobID = XxlJobUtils.addJob(job);
        return jobID;
    }
}

