/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.aop;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.aicheck.exception.CommonException;
import com.ovopark.aicheck.feign.SsoFeign;
import com.ovopark.aicheck.model.auth.Authenticator;
import com.ovopark.aicheck.model.auth.ClientInfo;
import com.ovopark.aicheck.model.auth.TokenValue;
import com.ovopark.aicheck.model.auth.Users;
import com.ovopark.aicheck.result.BaseResult;
import com.ovopark.aicheck.result.ReturnCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class AuthenticationInterceptor
implements HandlerInterceptor {
    @Autowired
    private SsoFeign ssoFeign;
    private static final Logger log = LoggerFactory.getLogger(AuthenticationInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String wdzToken = request.getHeader("Ovo-Authorization");
        log.info("=========\u4e07\u5e97\u638c\u7cfb\u7edf\u7528\u6237Token\u9a8c\u8bc1\uff0cOvo-Authorization={}", (Object)wdzToken);
        if (StringUtils.isEmpty((CharSequence)wdzToken)) {
            throw new CommonException(ReturnCode.TOKEN_LOST);
        }
        if (StringUtils.isNotEmpty((CharSequence)wdzToken)) {
            String[] auths = wdzToken.split(" ");
            String token = auths[0];
            log.info("=========\u4e07\u5e97\u638c\u7cfb\u7edf\u7528\u6237Token\u9a8c\u8bc1\uff0ctoken={}", (Object)token);
            BaseResult<TokenValue> ret = this.ssoFeign.parseToken(token);
            log.info("=========\u4e07\u5e97\u638c\u7cfb\u7edf\u7528\u6237Token\u9a8c\u8bc1\uff0ctoken={}\uff0c\u8fd4\u56de\uff1a{}", (Object)token, ret);
            if (ret.getIsError().booleanValue() || ret.getData() == null) {
                throw new CommonException(ReturnCode.TOKEN_EXPIRATION);
            }
            TokenValue wdzTokenInfo = ret.getData();
            ClientInfo clientInfo = new ClientInfo();
            clientInfo.setUserId(wdzTokenInfo.getUserId());
            clientInfo.setUserName(wdzTokenInfo.getUserName());
            Users user = new Users();
            user.setId(wdzTokenInfo.getUserId());
            user.setUserName(wdzTokenInfo.getUserName());
            user.setGroupId(wdzTokenInfo.getGroupId());
            clientInfo.setUser(user);
            Authenticator.getInstance().setCurrentClient(clientInfo);
            this.validateUserPermission(request, handler, user);
            return true;
        }
        return false;
    }

    private void validateUserPermission(HttpServletRequest request, Object handler, Users user) {
        if (user.getGroupId() == null || StringUtils.isEmpty((CharSequence)user.getGroupId().toString())) {
            log.info("=========\u6743\u9650\u6821\u9a8c\uff1a\u7528\u6237\u4e3a\u8d85\u7ba1\uff08groupId\u4e3a\u7a7a\uff09\uff0c\u8df3\u8fc7\u6240\u6709\u6743\u9650\u6821\u9a8c\uff0cuserId={}", (Object)user.getId());
            return;
        }
        log.info("=========\u6743\u9650\u6821\u9a8c\uff1a\u7528\u6237\u975e\u8d85\u7ba1\uff08groupId={}\uff09\uff0c\u5f00\u59cb\u53c2\u6570\u6821\u9a8c\uff0cuserId={}", (Object)user.getGroupId(), (Object)user.getId());
        String paramGroupId = null;
        String paramEnterpriseId = null;
        try {
            paramGroupId = request.getParameter("groupId");
            paramEnterpriseId = request.getParameter("enterpriseId");
            String contentType = request.getContentType();
            if (contentType != null && contentType.contains("application/json")) {
                StringBuilder sb = new StringBuilder();
                try (BufferedReader reader = request.getReader();){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                }
                String jsonString = sb.toString();
                if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
                    JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
                    if (paramGroupId == null) {
                        paramGroupId = jsonObject.getString("groupId");
                    }
                    if (paramEnterpriseId == null) {
                        paramEnterpriseId = jsonObject.getString("enterpriseId");
                    }
                }
            }
            if (handler instanceof HandlerMethod) {
                HandlerMethod handlerMethod = (HandlerMethod)handler;
                if (paramGroupId == null) {
                    paramGroupId = this.getFieldValueFromHandlerMethod(handlerMethod, "groupId");
                }
                if (paramEnterpriseId == null) {
                    paramEnterpriseId = this.getFieldValueFromHandlerMethod(handlerMethod, "enterpriseId");
                }
            }
            String checkValue = null;
            if (StringUtils.isNotEmpty((CharSequence)paramGroupId)) {
                checkValue = paramGroupId;
                log.info("=========\u6743\u9650\u6821\u9a8c\uff1a\u4ece\u53c2\u6570\u4e2d\u89e3\u6790\u5230groupId={}", (Object)checkValue);
            } else if (StringUtils.isNotEmpty((CharSequence)paramEnterpriseId)) {
                checkValue = paramEnterpriseId;
                log.info("=========\u6743\u9650\u6821\u9a8c\uff1a\u4ece\u53c2\u6570\u4e2d\u89e3\u6790\u5230enterpriseId={}", (Object)checkValue);
            }
            if (checkValue == null) {
                log.info("=========\u6743\u9650\u6821\u9a8c\uff1a\u63a5\u53e3\u672a\u4f20\u5165groupId/enterpriseId\u53c2\u6570\uff0c\u8df3\u8fc7\u6743\u9650\u6821\u9a8c\uff0cuserId={}", (Object)user.getId());
                return;
            }
            String userGroupIdStr = user.getGroupId().toString();
            if (!userGroupIdStr.equals(checkValue)) {
                log.error("=========\u6743\u9650\u6821\u9a8c\u5931\u8d25\uff1a\u7528\u6237groupId={}\uff0c\u53c2\u6570\u4e2d\u7684groupId/enterpriseId={}\uff0c\u65e0\u64cd\u4f5c\u6743\u9650\uff0cuserId={}", new Object[]{userGroupIdStr, checkValue, user.getId()});
                throw new CommonException(ReturnCode.FORBIDDEN_ACCESS);
            }
            log.info("=========\u6743\u9650\u6821\u9a8c\u901a\u8fc7\uff1a\u7528\u6237groupId={}\uff0c\u53c2\u6570\u503c={}\uff0cuserId={}", new Object[]{userGroupIdStr, checkValue, user.getId()});
        }
        catch (CommonException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("=========\u6743\u9650\u6821\u9a8c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new CommonException(ReturnCode.PARAM_ERROR);
        }
    }

    private String getFieldValueFromHandlerMethod(HandlerMethod handlerMethod, String fieldName) {
        try {
            MethodParameter[] methodParameters;
            for (MethodParameter parameter : methodParameters = handlerMethod.getMethodParameters()) {
                String fieldValue;
                Parameter paramObject;
                Class paramType = parameter.getParameterType();
                if (paramType.isPrimitive() || paramType == String.class || paramType == Integer.class || (paramObject = parameter.getParameter()) == null || !StringUtils.isNotEmpty((CharSequence)(fieldValue = this.getFieldValueRecursively(paramObject, fieldName)))) continue;
                return fieldValue;
            }
        }
        catch (Exception e) {
            log.warn("=========\u53cd\u5c04\u89e3\u6790\u53c2\u6570\u5b57\u6bb5{}\u5931\u8d25\uff0c\u5ffd\u7565\u8be5\u65b9\u5f0f", (Object)fieldName, (Object)e);
        }
        return null;
    }

    private String getFieldValueRecursively(Object obj, String fieldName) throws IllegalAccessException {
        if (obj == null) {
            return null;
        }
        for (Class<?> clazz = obj.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                Object value = field.get(obj);
                return value != null ? value.toString() : null;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    private Integer getEnterpriseIdFromHeader(HttpServletRequest request) {
        String enterpriseId = request.getHeader("enterpriseId");
        if (enterpriseId == null) {
            throw new CommonException(ReturnCode.PARAM_ERROR);
        }
        return Integer.parseInt(enterpriseId);
    }

    private Integer getEnterpriseIdFromParams(HttpServletRequest request) {
        String contentType = request.getContentType();
        log.info("=====> root - Content-Type\uff1a{}", (Object)contentType);
        if (contentType == null) {
            throw new CommonException(ReturnCode.REQUEST_ERROR);
        }
        String fieldValue = null;
        if (contentType.contains("application/json")) {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = request.getReader();){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (IOException e) {
                throw new CommonException(ReturnCode.PARAM_ERROR);
            }
            String jsonString = sb.toString();
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            fieldValue = jsonObject.getString("enterpriseId");
        } else {
            fieldValue = contentType.contains("multipart/form-data") ? request.getParameter("enterpriseId") : (contentType.contains("application/x-www-form-urlencoded") ? request.getParameter("enterpriseId") : request.getParameter("enterpriseId"));
        }
        if (StringUtils.isEmpty((CharSequence)fieldValue)) {
            throw new CommonException(ReturnCode.PARAM_ERROR);
        }
        return Integer.parseInt(fieldValue);
    }
}

