/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.aicheck.constant.enums;

import org.apache.commons.lang.StringUtils;

public enum ModelChannelEnum {
    CLOUD("000", "\u4e91\u7aef"),
    A1("100", "A1"),
    DOLPHIN1_A("200", "NVR"),
    PC4I("300", "PC4i "),
    PC8_B("301", "PC8-B ");

    private final String code;
    private final String channel;

    private ModelChannelEnum(String code, String channel) {
        this.code = code;
        this.channel = channel;
    }

    public static String mappingChannelEnum(String modelIdentifier) {
        ModelChannelEnum[] values;
        if (StringUtils.isEmpty((String)modelIdentifier) || modelIdentifier.length() < 4) {
            return "";
        }
        String code = modelIdentifier.substring(1, 4);
        for (ModelChannelEnum value : values = ModelChannelEnum.values()) {
            if (!value.getCode().equals(code)) continue;
            return value.getChannel();
        }
        return "";
    }

    public String getCode() {
        return this.code;
    }

    public String getChannel() {
        return this.channel;
    }
}

