package com.ovopark.marketing.api;

import com.ovopark.marketing.common.model.CommonResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author : S.  J Y
 * @description
 * @date : 2024-05-10 10:22
 **/
@FeignClient(value = "boss-marketing")
public interface MarketingFixedApi {

    @RequestMapping("/boss-marketing/api/boss/marketing/xiaoyin/sendXiaoYinPlayTask")
    CommonResult sendXiaoYinPlayTask(@RequestParam String deviceIds);

    @RequestMapping("/boss-marketing/api/boss/marketing/config/marketing/deleteDeviceById")
    CommonResult deleteDeviceById(@RequestParam Long deviceId,
                                  @RequestParam Long userId,
                                  @RequestParam(required = false) Long groupId,
                                  @RequestParam(required = false) String showName,
                                  @RequestParam(required = false) String userName);

    @RequestMapping("/boss-marketing/api/boss/marketing/xiaoyin/marketing/delXiaoYinDevice")
    CommonResult delXiaoYinDevice(@RequestParam(required = false) Long deviceId,
                                  @RequestParam(required = false) Integer deptId,
                                  @RequestParam Long userId,
                                  @RequestParam(required = false) Long groupId,
                                  @RequestParam(required = false) String showName,
                                  @RequestParam(required = false) String userName);
}
