/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.construction.common.domain;

import java.time.LocalDateTime;

public abstract class AggregateRoot<T> {
    private T id;
    private LocalDateTime createTime;
    private LocalDateTime updateTime;

    protected AggregateRoot(T id) {
        this.id = id;
    }

    protected AggregateRoot(LocalDateTime createTime, LocalDateTime updateTime) {
        this.createTime = createTime;
        this.updateTime = updateTime;
    }

    protected AggregateRoot(LocalDateTime createTime, LocalDateTime updateTime, T id) {
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.id = id;
    }

    public void updateTimestamps(LocalDateTime createTime, LocalDateTime updateTime) {
        this.updateTime = updateTime;
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateRoot that = (AggregateRoot)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "AggregateRoot{id=" + String.valueOf(this.id) + "}";
    }

    public T getId() {
        return this.id;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    protected AggregateRoot() {
    }
}

