/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.construction.common.redis;

import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class RedisConfig {
    @Value(value="${redisConfig.redis.one.host}")
    private String redisOneHost;
    @Value(value="${redisConfig.redis.one.port}")
    private int redisOnePort;
    @Value(value="${redisConfig.redis.one.password}")
    private String redisOnePassword;
    @Value(value="${redisConfig.redis.one.database}")
    private int redisOneDatabase;
    @Value(value="${redisConfig.redis.two.host}")
    private String redisTwoHost;
    @Value(value="${redisConfig.redis.two.port}")
    private int redisTwoPort;
    @Value(value="${redisConfig.redis.two.password}")
    private String redisTwoPassword;
    @Value(value="${redisConfig.redis.two.database}")
    private int redisTwoDatabase;
    @Value(value="${redisConfig.redis.one.timeout}")
    private int redisTimeout;
    @Value(value="${redisConfig.redis.lettuce.pool.max-total}")
    private int redisMaxTotal;
    @Value(value="${redisConfig.redis.lettuce.pool.max-idle}")
    private int redisMaxIdle;
    @Value(value="${redisConfig.redis.lettuce.pool.max-wait-millis}")
    private int redisMaxWaitMills;
    @Value(value="${redisConfig.redis.lettuce.pool.min-idle}")
    private int redisMinIdle;

    @Bean(name={"redisTemplateOne"})
    public StringRedisTemplate redisTemplateOne(@Qualifier(value="redisConnectionFactoryOne") RedisConnectionFactory redisConnectionFactory) {
        StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory(redisConnectionFactory);
        stringRedisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        stringRedisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        stringRedisTemplate.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        stringRedisTemplate.setHashValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        stringRedisTemplate.afterPropertiesSet();
        return stringRedisTemplate;
    }

    @Bean(value={"redisConnectionFactoryOne"})
    public RedisConnectionFactory redisConnectionFactoryOne(@Qualifier(value="redisConfigOne") RedisProperties redisProperties) {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(redisProperties.getHost());
        config.setPort(redisProperties.getPort());
        config.setPassword(redisProperties.getPassword());
        config.setDatabase(redisProperties.getDatabase());
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(this.redisMaxIdle);
        poolConfig.setMinIdle(this.redisMinIdle);
        poolConfig.setMaxTotal(this.redisMaxTotal);
        poolConfig.setMaxWaitMillis((long)this.redisMaxWaitMills);
        LettucePoolingClientConfiguration clientConfiguration = LettucePoolingClientConfiguration.builder().poolConfig(poolConfig).build();
        LettuceConnectionFactory lettuceConnectionFactory = new LettuceConnectionFactory(config, (LettuceClientConfiguration)clientConfiguration);
        return lettuceConnectionFactory;
    }

    @Bean(value={"redisConfigOne"})
    public RedisProperties redisConfigOne() {
        RedisProperties redisProperties = new RedisProperties();
        redisProperties.setHost(this.redisOneHost);
        redisProperties.setPort(this.redisOnePort);
        redisProperties.setPassword(this.redisOnePassword);
        redisProperties.setDatabase(this.redisOneDatabase);
        redisProperties.setTimeout(Duration.ofMillis(this.redisTimeout));
        return redisProperties;
    }

    @Bean(name={"redisTemplateTwo"})
    public RedisTemplate<String, Object> redisTemplateTwo(@Qualifier(value="redisConnectionFactoryTwo") RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        redisTemplate.setHashValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean(value={"redisConnectionFactoryTwo"})
    public RedisConnectionFactory redisConnectionFactoryTwo(@Qualifier(value="redisConfigTwo") RedisProperties redisProperties) {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(redisProperties.getHost());
        config.setPort(redisProperties.getPort());
        config.setPassword(redisProperties.getPassword());
        config.setDatabase(redisProperties.getDatabase());
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(this.redisMaxIdle);
        poolConfig.setMinIdle(this.redisMinIdle);
        poolConfig.setMaxTotal(this.redisMaxTotal);
        poolConfig.setMaxWaitMillis((long)this.redisMaxWaitMills);
        LettucePoolingClientConfiguration clientConfiguration = LettucePoolingClientConfiguration.builder().poolConfig(poolConfig).build();
        LettuceConnectionFactory lettuceConnectionFactory = new LettuceConnectionFactory(config, (LettuceClientConfiguration)clientConfiguration);
        return lettuceConnectionFactory;
    }

    @Bean(value={"redisConfigTwo"})
    public RedisProperties redisConfigTwo() {
        RedisProperties redisProperties = new RedisProperties();
        redisProperties.setHost(this.redisTwoHost);
        redisProperties.setPort(this.redisTwoPort);
        redisProperties.setPassword(this.redisTwoPassword);
        redisProperties.setDatabase(this.redisTwoDatabase);
        redisProperties.setTimeout(Duration.ofMillis(this.redisTimeout));
        return redisProperties;
    }
}

