/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.construction.common.redis;

import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RedisUtils {
    @Resource(name="redisTemplateOne")
    private StringRedisTemplate template;
    private static DefaultRedisScript<Long> limitScript = new DefaultRedisScript();
    private static DefaultRedisScript<String> seckillScript;
    private static DefaultRedisScript<Long> limitReportScript;
    private static DefaultRedisScript<Long> withdrawNonceScript;
    private static DefaultRedisScript<Long> withdrawLockScript;
    private static DefaultRedisScript<Long> ordinaryLockScript;
    private static DefaultRedisScript<Long> completeWithdrawLockScript;
    private static DefaultRedisScript<Long> orderGrabbingSMSScript;

    public String seckill(List<String> keys) {
        String none = (String)this.template.execute(seckillScript, keys, new Object[]{"none"});
        return none;
    }

    public boolean currentLimiting(String key, Integer count) {
        List<String> keys = Collections.singletonList(key);
        Long result = (Long)this.template.execute(limitScript, keys, new Object[]{"1", count.toString()});
        return result > 0L;
    }

    public Long reportRateLimter(List<String> keys) {
        Long result = (Long)this.template.execute(limitReportScript, keys, new Object[0]);
        return result;
    }

    public boolean expire(String key, long time) {
        return this.template.expire((Object)key, time, TimeUnit.SECONDS);
    }

    public long getExpire(String key) {
        return this.template.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public String get(String key) {
        ValueOperations ops = this.template.opsForValue();
        return (String)ops.get((Object)key);
    }

    public Long increment(String key) {
        try {
            ValueOperations ops = this.template.opsForValue();
            return ops.increment((Object)key, 1L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public boolean setExpireset(String key, String value) {
        try {
            ValueOperations ops = this.template.opsForValue();
            ops.set((Object)key, (Object)value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setExpire(String key, String value, long time) {
        try {
            ValueOperations ops = this.template.opsForValue();
            ops.set((Object)key, (Object)value, time, TimeUnit.SECONDS);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void delete(String key) {
        this.template.delete((Object)key);
    }

    public boolean hasKey(String key) {
        try {
            return this.template.hasKey((Object)key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object hget(String key, String item) {
        return this.template.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return this.template.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<Object, Object> map) {
        try {
            this.template.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hmsetExpire(String key, Map<String, Object> map, long time) {
        try {
            this.template.opsForHash().putAll((Object)key, map);
            this.expire(key, time);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            this.template.opsForHash().putIfAbsent((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hincrby(String key, String field, Integer num) {
        try {
            this.template.opsForHash().increment((Object)key, (Object)field, (long)num.intValue());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hsetExpire(String key, String item, Object value, long time) {
        try {
            this.template.opsForHash().put((Object)key, (Object)item, (Object)item);
            this.expire(key, time);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void hdelete(String key, Object ... items) {
        this.template.opsForHash().delete((Object)key, items);
    }

    public void sdelete(String key, String item) {
        this.template.opsForSet().remove((Object)key, new Object[]{item});
    }

    public boolean hHasKey(String key, String item) {
        try {
            return this.template.opsForHash().hasKey((Object)key, (Object)item);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Set<String> sGet(String key) {
        return this.template.opsForSet().members((Object)key);
    }

    public boolean sHasKey(String key, String value) {
        try {
            return this.template.opsForSet().isMember((Object)key, (Object)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long sSet(String key, String ... values) {
        return this.template.opsForSet().add((Object)key, (Object[])values);
    }

    public long sSetExpire(String key, long time, String ... values) {
        Long count = this.template.opsForSet().add((Object)key, (Object[])values);
        this.expire(key, time);
        return count;
    }

    public long sGetSetSize(String key) {
        return this.template.opsForSet().size((Object)key);
    }

    public long setRemove(String key, Object ... values) {
        return this.template.opsForSet().remove((Object)key, values);
    }

    public List<String> lGet(String key, long start, long end) {
        try {
            return this.template.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return this.template.opsForList().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public String lGetIndex(String key, long index) {
        try {
            return (String)this.template.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean lSet(String key, String value) {
        try {
            this.template.opsForList().rightPush((Object)key, (Object)value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSetExpire(String key, String value, long time) {
        try {
            this.template.opsForList().rightPush((Object)key, (Object)value);
            this.expire(key, time);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, List<String> values) {
        try {
            this.template.opsForList().rightPushAll((Object)key, values);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSetExpire(String key, List<String> values, long time) {
        try {
            this.template.opsForList().rightPushAll((Object)key, values);
            this.expire(key, time);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, String value) {
        try {
            this.template.opsForList().set((Object)key, index, (Object)value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long lRemote(String key, long count, String value) {
        try {
            return this.template.opsForList().remove((Object)key, count, (Object)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long leftPush(String key, String value) {
        try {
            return this.template.opsForList().leftPush((Object)key, (Object)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public String rightPop(String key) {
        try {
            return (String)this.template.opsForList().rightPop((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean setHashValue(String hashName, String hashKey, Object hashValue) {
        boolean flag = false;
        try {
            System.out.println("=============================:hashName:" + hashName);
            this.template.opsForHash().put((Object)hashName, (Object)hashKey, hashValue);
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public boolean set(String key, String value) {
        try {
            ValueOperations ops = this.template.opsForValue();
            ops.set((Object)key, (Object)value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean checkNonce(String nonce) {
        String key = "nonc1";
        HashSet<String> nonceList = this.template.opsForSet().members((Object)key);
        if (CollectionUtils.isEmpty((Collection)nonceList)) {
            nonceList = new HashSet<String>();
        } else if (nonceList.contains(nonce)) {
            return false;
        }
        nonceList.add(nonce);
        this.template.opsForValue().set((Object)key, (Object)nonce, 24L, TimeUnit.HOURS);
        return true;
    }

    public String createIncrement(String key, Integer num) {
        Long increment = this.template.opsForValue().increment((Object)key, (long)num.intValue());
        this.template.expire((Object)key, 1L, TimeUnit.HOURS);
        return increment.toString();
    }

    public boolean withdrawNonceRedis(List<String> keys, Long expire) {
        Long result = (Long)this.template.execute(withdrawNonceScript, keys, new Object[]{"" + expire});
        if (result == 1L) {
            return true;
        }
        return result != 0L;
    }

    public Long withdrawLockRedis(List<String> keys, Long expire) {
        Long result = (Long)this.template.execute(withdrawLockScript, keys, new Object[]{"" + expire});
        return result;
    }

    public boolean ordinaryLock(List<String> keys, Long expire) {
        Long result = (Long)this.template.execute(ordinaryLockScript, keys, new Object[]{"" + expire});
        return result == 1L;
    }

    public boolean completeWithdrawLock(List<String> keys, Long expire) {
        Long result = (Long)this.template.execute(completeWithdrawLockScript, keys, new Object[]{"" + expire});
        return result == 1L;
    }

    public Set<String> scanKeys(String key) {
        Set keys = this.template.keys((Object)(key + "*"));
        return keys;
    }

    public Boolean checkOrabbingSMS(List<String> keys, Long timeStamp) {
        Long result = (Long)this.template.execute(orderGrabbingSMSScript, keys, new Object[]{"" + timeStamp});
        if (result == 1L) {
            return true;
        }
        return false;
    }

    public void setKeyAndExpirationTime(String key, String value, long time, TimeUnit timeUnit) {
        this.template.opsForValue().set((Object)key, (Object)value, time, timeUnit);
    }

    public Set<String> getAllKeys() {
        Set keys = this.template.keys((Object)"*");
        return keys;
    }

    static {
        limitScript.setResultType(Long.class);
        limitScript.setScriptSource((ScriptSource)new ResourceScriptSource((org.springframework.core.io.Resource)new ClassPathResource("/lua/rateLimter.lua")));
        seckillScript = new DefaultRedisScript();
        seckillScript.setResultType(String.class);
        seckillScript.setScriptSource((ScriptSource)new ResourceScriptSource((org.springframework.core.io.Resource)new ClassPathResource("/lua/seckill.lua")));
        limitReportScript = new DefaultRedisScript();
        limitReportScript.setResultType(Long.class);
        limitReportScript.setScriptSource((ScriptSource)new ResourceScriptSource((org.springframework.core.io.Resource)new ClassPathResource("/lua/reportRateLimter.lua")));
        withdrawNonceScript = new DefaultRedisScript();
        withdrawNonceScript.setResultType(Long.class);
        withdrawNonceScript.setScriptSource((ScriptSource)new ResourceScriptSource((org.springframework.core.io.Resource)new ClassPathResource("/lua/withdraw-nonce.lua")));
        withdrawLockScript = new DefaultRedisScript();
        withdrawLockScript.setResultType(Long.class);
        withdrawLockScript.setScriptSource((ScriptSource)new ResourceScriptSource((org.springframework.core.io.Resource)new ClassPathResource("/lua/withdraw-lock.lua")));
        ordinaryLockScript = new DefaultRedisScript();
        ordinaryLockScript.setResultType(Long.class);
        ordinaryLockScript.setScriptSource((ScriptSource)new ResourceScriptSource((org.springframework.core.io.Resource)new ClassPathResource("/lua/ordinary-lock.lua")));
        completeWithdrawLockScript = new DefaultRedisScript();
        completeWithdrawLockScript.setResultType(Long.class);
        completeWithdrawLockScript.setScriptSource((ScriptSource)new ResourceScriptSource((org.springframework.core.io.Resource)new ClassPathResource("/lua/complete-withdraw-lock.lua")));
        orderGrabbingSMSScript = new DefaultRedisScript();
        orderGrabbingSMSScript.setResultType(Long.class);
        orderGrabbingSMSScript.setScriptSource((ScriptSource)new ResourceScriptSource((org.springframework.core.io.Resource)new ClassPathResource("/lua/order-grabbing-sms.lua")));
    }
}

