/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.construction.common.utils;

import java.time.LocalDate;
import java.util.Random;
import org.springframework.util.StringUtils;

public class OtherUtil {
    public static String getRandomInvitationCode() {
        String str = "0ABCDEF6GHIJ9KL3MN8OPQ5RST7UVW1XYZ24";
        StringBuffer sb = new StringBuffer();
        Random r = new Random();
        for (int i = 0; i < 4; ++i) {
            sb.append(str.charAt(r.nextInt(36)));
        }
        return sb.toString();
    }

    public static String getRandomInvitationCode103() {
        String str = "0abcdefg1hijklm9nop3qrstuvw5xyzABCDEF6GHIJKLMN8OPQRST7UVWXYZ24";
        StringBuffer sb = new StringBuffer();
        Random r = new Random();
        for (int i = 0; i < 4; ++i) {
            sb.append(str.charAt(r.nextInt(36)));
        }
        return sb.toString();
    }

    public static String getAuthCode() {
        StringBuffer sb = new StringBuffer();
        Random r = new Random();
        for (int i = 0; i < 4; ++i) {
            sb.append(r.nextInt(10));
        }
        return sb.toString();
    }

    public static boolean checkPwd(String pwd) {
        String regex = "(?=^.{8,30}$)(?=^.*?(?:[0-9]).*$)(?=^.*?(?:[a-zA-Z]).*$).+";
        return pwd.matches(regex);
    }

    public static boolean checkPhone(String phone) {
        String regex = "^(13[0-9]|14[01456879]|15[0-35-9]|16[2567]|17[0-8]|18[0-9]|19[0-35-9])\\d{8}$";
        return phone.matches(regex);
    }

    public static boolean checkNickName(String showName) {
        String regex = "^(?!_)(?!-)[0-9a-zA-Z\u4e00-\u9fa5_-]{1,24}$";
        return showName.matches(regex);
    }

    public static boolean checkEmail(String email) {
        String regex = "^\\s*\\w+(?:\\.{0,1}[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$";
        return email.matches(regex);
    }

    public static int getAgeByIDNumber(String IDNumber) {
        LocalDate now = LocalDate.now();
        Integer year = now.getYear();
        Integer month = now.getMonthValue();
        Integer dayOfMonth = now.getDayOfMonth();
        Integer uYear = Integer.valueOf(IDNumber.substring(6, 10));
        Integer uMonth = Integer.valueOf(IDNumber.substring(10, 12));
        Integer uDay = Integer.valueOf(IDNumber.substring(12, 14));
        Integer rYear = year - uYear;
        Integer rMonth = month - uMonth;
        Integer rDay = dayOfMonth - uDay;
        int age = rYear;
        if (rYear <= 0) {
            age = 0;
        } else if (rMonth == 0) {
            if (rDay < 0) {
                --age;
            }
        } else if (rMonth > 0) {
            ++age;
        }
        return age;
    }

    public static String getDesensitization(String str) {
        String regex = "^[\\u4e00-\\u9fa5]+$";
        StringBuilder sb = new StringBuilder("");
        if (str.matches(regex)) {
            for (int i = 0; i < str.length() - 1; ++i) {
                sb.append("*");
            }
            return sb.append(str.charAt(str.length() - 1)).toString();
        }
        if (OtherUtil.checkEmail(str)) {
            String[] split = str.split("@");
            for (int i = 0; i < split[0].length() - 2; ++i) {
                sb.append("*");
            }
            return sb.append(split[0].substring(split[0].length() - 2)).append("@").append(split[1]).toString();
        }
        if (OtherUtil.checkPhone(str)) {
            return str.substring(0, 2) + "******" + str.substring(8, 11);
        }
        for (int i = 0; i < str.length() - 4; ++i) {
            sb.append("*");
        }
        return sb.toString() + str.substring(str.length() - 4);
    }

    public static boolean checkIDNumber(String IDNumber) {
        String regex = "^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$|^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9]|X|x)$";
        return IDNumber.matches(regex);
    }

    public static String removeSpecialSymbols(String str) {
        String regex = "\\[.*?]";
        return str.replaceAll(regex, "").trim();
    }

    public static String getDesensitizationinvitationCode(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return str;
        }
        try {
            return str.substring(0, 1) + "**" + str.substring(3);
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
    }

    public static void main(String[] args) {
        System.out.println(OtherUtil.getDesensitization("\u738b\u5e05"));
        System.out.println(OtherUtil.getDesensitization("646415412485846642"));
        System.out.println(OtherUtil.removeSpecialSymbols("[0:0.000,0:7.452]  Web\u8bed\u97f3\u5f55\u5165\u6d4b\u8bd50.01\u63d0\u4ea4\u62a5\u544a\u3002\n"));
    }
}

