/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.construction.common.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.RandomUtils;

public class SnowflakeIdGenerator {
    private static final long EPOCH = 1577840461000L;
    private static final long WORKER_ID_BITS = 12L;
    private static final long SEQUENCE_BITS = 10L;
    private static final long SEQUENCE_MASK = 1023L;
    private static final long WORKER_ID_LEFT_SHIFT_BITS = 10L;
    private static final long TIMESTAMP_LEFT_SHIFT_BITS = 22L;
    private static final long WORKER_ID_MAX_VALUE = 4095L;
    private static final int MAX_TIMESTAMP_BACKWARDS_TO_WAIT = 10;
    private static SnowflakeIdGenerator INSTANCE;
    private final long WORKER_ID;
    private long sequence;
    private long lastTimestamp = -1L;

    private SnowflakeIdGenerator(long workerId) {
        if (workerId > 4095L || workerId < 1L) {
            throw new IllegalArgumentException(String.format("worker id can't be greater than %d or less than 1", 4095L));
        }
        this.WORKER_ID = workerId;
    }

    private static synchronized SnowflakeIdGenerator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SnowflakeIdGenerator(SnowflakeIdGenerator.getWorkerId());
        }
        return INSTANCE;
    }

    private static long getWorkerId() {
        try {
            String[] ips = InetAddress.getLocalHost().getHostAddress().split("\\.");
            if (ips.length <= 1) {
                return RandomUtils.nextLong((long)1L, (long)1000L);
            }
            long subnet = Long.parseLong(ips[2]);
            long machine = Long.parseLong(ips[3]);
            return (subnet & 0xFL) << 8 | machine;
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Cannot get worker ID.", e);
        }
    }

    public static long newSnowflakeId() {
        return SnowflakeIdGenerator.getInstance().getNextId();
    }

    private synchronized long getNextId() {
        long currentTimestamp = this.getCurrentTimestamp();
        if (this.tolerateTimestampBackwardsIfNeed(currentTimestamp)) {
            currentTimestamp = this.getCurrentTimestamp();
        }
        if (this.lastTimestamp == currentTimestamp) {
            if (this.sequenceIncreaseIfReachLimitReset()) {
                currentTimestamp = this.waitUntilNextTime(currentTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTimestamp;
        return currentTimestamp - 1577840461000L << 22 | this.WORKER_ID << 10 | this.sequence;
    }

    private boolean tolerateTimestampBackwardsIfNeed(long curTimestamp) {
        if (this.lastTimestamp <= curTimestamp) {
            return false;
        }
        long timeDifference = this.lastTimestamp - curTimestamp;
        if (timeDifference >= 10L) {
            throw new RuntimeException("machine clock moved backward too much");
        }
        this.waitUntilNextTime(this.lastTimestamp);
        return true;
    }

    private boolean sequenceIncreaseIfReachLimitReset() {
        this.sequence = this.sequence + 1L & 0x3FFL;
        return 0L == this.sequence;
    }

    private long waitUntilNextTime(long timestampToContinue) {
        long timestamp;
        while ((timestamp = this.getCurrentTimestamp()) <= timestampToContinue) {
        }
        return timestamp;
    }

    private long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }
}

