/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.construction.common.utils.response;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.construction.common.utils.response.ReturnCodeBase;

public class ResultBody {
    private String code;
    private String message;
    private Object result;
    private Object data;
    private boolean IsError;
    private Object warning;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getWarning() {
        return this.warning;
    }

    public void setWarning(Object warning) {
        this.warning = warning;
    }

    public static ResultBody success() {
        ResultBody rb = new ResultBody();
        rb.setCode("0");
        rb.setMessage(ReturnCodeBase.SUCCESS.getName());
        rb.setData(null);
        rb.setIsError(false);
        rb.setResult(ReturnCodeBase.SUCCESS.getDesc());
        return rb;
    }

    public static ResultBody success(Object data) {
        ResultBody rb = new ResultBody();
        rb.setCode("0");
        rb.setMessage(ReturnCodeBase.SUCCESS.getName());
        rb.setData(data);
        rb.setIsError(false);
        rb.setResult(ReturnCodeBase.SUCCESS.getDesc());
        return rb;
    }

    public static ResultBody success(String code, String message, Object data, String desc) {
        ResultBody rb = new ResultBody();
        rb.setCode(code);
        rb.setMessage(message);
        rb.setIsError(false);
        rb.setData(data);
        rb.setResult(desc);
        return rb;
    }

    public static ResultBody error() {
        ResultBody rb = new ResultBody();
        rb.setCode("-1");
        rb.setMessage(ReturnCodeBase.ERROR.getName());
        rb.setIsError(true);
        rb.setResult(ReturnCodeBase.ERROR.getDesc());
        return rb;
    }

    public static ResultBody error(String code, String message, Object data, String desc) {
        ResultBody rb = new ResultBody();
        rb.setCode(code);
        rb.setMessage(message);
        rb.setData(data);
        rb.setIsError(true);
        rb.setResult(desc);
        return rb;
    }

    public static ResultBody errorParam(String code, String message, Object data, String desc, Object warning) {
        ResultBody rb = new ResultBody();
        rb.setCode(code);
        rb.setMessage(message);
        rb.setData(data);
        rb.setIsError(true);
        rb.setResult(desc);
        rb.setWarning(warning);
        return rb;
    }

    public static ResultBody paramError() {
        ResultBody rb = new ResultBody();
        rb.setCode("20000001");
        rb.setMessage(ReturnCodeBase.PARAM_ERROR.getName());
        rb.setIsError(true);
        rb.setData(null);
        rb.setResult(ReturnCodeBase.PARAM_ERROR.getDesc());
        return rb;
    }

    public static ResultBody paramError(Object data) {
        ResultBody rb = new ResultBody();
        rb.setCode("20000001");
        rb.setMessage(ReturnCodeBase.PARAM_ERROR.getName());
        rb.setIsError(true);
        rb.setData(data);
        rb.setResult(ReturnCodeBase.PARAM_ERROR.getDesc());
        return rb;
    }

    public static ResultBody paramError(Object data, Object warning) {
        ResultBody rb = new ResultBody();
        rb.setCode("20000001");
        rb.setMessage(ReturnCodeBase.PARAM_ERROR.getName());
        rb.setIsError(true);
        rb.setData(data);
        rb.setResult(ReturnCodeBase.PARAM_ERROR.getDesc());
        rb.setWarning(warning);
        return rb;
    }

    public String toString() {
        return JSONObject.toJSONString((Object)this);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean isIsError() {
        return this.IsError;
    }

    public void setIsError(boolean IsError) {
        this.IsError = IsError;
    }
}

