/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.construction.common.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateTimeUtils {
    private static String zoneId = "Asia/Shanghai";
    public static String dateFormat = "yyyy-MM-dd HH:mm:ss";

    public static LocalDateTime stringToDate(String dateTime, String dateFormat) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(dateFormat);
        LocalDateTime localDateTime = LocalDateTime.parse(dateTime, dateTimeFormatter);
        return localDateTime;
    }

    public static String dateToString(LocalDateTime localDateTime) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(dateFormat);
        String format = dateTimeFormatter.format(localDateTime);
        return format;
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zoneId);
        return localDateTime;
    }

    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static LocalDateTime longToLocalDateTime(long time) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault());
    }

    public static long localDateTimeToLong(LocalDateTime ldt) {
        return ldt.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static void main(String[] args) {
        LocalDateTime localDateTime = DateTimeUtils.stringToDate("2019-12-19 20:23:54", dateFormat);
        System.out.println("\u5b57\u7b26\u4e32\u8f6c\u6362\u65f6\u95f4\uff1a" + String.valueOf(localDateTime));
        String date = DateTimeUtils.dateToString(LocalDateTime.now());
        System.out.println("\u65f6\u95f4\u8f6c\u6362\u5b57\u7b26\u4e32\uff1a" + date);
        LocalDateTime localDateTime1 = DateTimeUtils.dateToLocalDateTime(new Date());
        System.out.println("Date\u8f6c\u6362LocalDateTime\uff1a" + String.valueOf(localDateTime1));
        Date date1 = DateTimeUtils.localDateTimeToDate(LocalDateTime.now());
        System.out.println("LocalDateTime\u8f6c\u6362Date\uff1a" + String.valueOf(date1));
        LocalDateTime localDateTime2 = DateTimeUtils.longToLocalDateTime(System.currentTimeMillis());
        System.out.println("\u6beb\u79d2\u8f6c\u6362LocalDateTime\uff1a" + String.valueOf(localDateTime2));
        long mills = DateTimeUtils.localDateTimeToLong(LocalDateTime.now());
        System.out.println("LocalDateTime\u8f6c\u6362\u6beb\u79d2\uff1a" + mills);
    }
}

