/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.log.collect.aop;

import com.alibaba.fastjson.JSON;
import com.ovopark.log.collect.context.LogContext;
import com.ovopark.log.collect.util.LogUtil;
import com.ovopark.log.collect.util.RequestUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class LogArgsAspect
implements InitializingBean {
    private final Logger logger = LogUtil.logger(LogArgsAspect.class);

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.Mapping) || @annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping) ||@annotation(org.springframework.web.bind.annotation.PutMapping) || @annotation(org.springframework.web.bind.annotation.PatchMapping) || @annotation(org.springframework.web.bind.annotation.DeleteMapping)")
    public void argsPointcut() {
    }

    @Before(value="argsPointcut()")
    public void beforeController(JoinPoint joinPoint) {
        try {
            Object[] argValues = joinPoint.getArgs();
            String[] argNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
            if (argNames == null || argValues == null) {
                return;
            }
            HashMap<String, Object> argMap = new HashMap<String, Object>(argNames.length);
            for (int i = 0; i < argNames.length; ++i) {
                Object argValue = argValues[i];
                if (argValue instanceof HttpServletRequest) {
                    Map parameterMap = ((HttpServletRequest)argValue).getParameterMap();
                    argMap.putAll(RequestUtil.convertQueryArgsMap(parameterMap));
                    continue;
                }
                if (argValue instanceof HttpServletResponse || argValue instanceof MultipartFile) continue;
                argMap.put(argNames[i], argValue);
            }
            if (!CollectionUtils.isEmpty(argMap)) {
                LogContext.setArgs((String)JSON.toJSONString(argMap));
            }
        }
        catch (Exception e) {
            LogUtil.SNEAKY_EXCEPTION_LOG.error(this.getClass().getName(), (Throwable)e);
        }
    }

    public void afterPropertiesSet() {
        this.logger.info("LogArgsAspect injected already");
    }
}

