/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.log.collect.aop;

import com.ovopark.log.collect.context.LogContext;
import com.ovopark.log.collect.util.LogUtil;
import com.ovopark.log.collect.util.RequestUtil;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class LogExceptionAspect
implements InitializingBean {
    private static final Logger LOG = LogUtil.logger(LogExceptionAspect.class);

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.ExceptionHandler)")
    public void exceptionPointcut() {
    }

    @Before(value="exceptionPointcut()")
    public void beforeException(JoinPoint joinPoint) {
        try {
            Object[] args;
            for (Object arg : args = joinPoint.getArgs()) {
                ServletRequestAttributes attributes;
                if (!(arg instanceof Exception)) continue;
                Exception ex = (Exception)arg;
                StackTraceElement stackTraceElement = ex.getStackTrace()[0];
                String method = stackTraceElement.getMethodName();
                String line = String.valueOf(stackTraceElement.getLineNumber());
                String clazz = stackTraceElement.getClassName();
                method = method + "(" + stackTraceElement.getFileName() + ":" + line + ")";
                LogContext.setExceptionClass((String)clazz);
                LogContext.setExceptionMethod((String)method);
                if (LogContext.getWithArgs() && (attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes()) != null) {
                    HttpServletRequest request = attributes.getRequest();
                    String uri = request.getRequestURI();
                    if (LogContext.isUncollectibleUrl((String)uri)) {
                        LogContext.setArgs(null);
                    } else if (LogContext.getArgs() == null) {
                        LogContext.setArgs((String)RequestUtil.getArgsByRequest(request));
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            LogUtil.SNEAKY_EXCEPTION_LOG.error(this.getClass().getName(), (Throwable)e);
        }
    }

    public void afterPropertiesSet() {
        LOG.info("LogExceptionAspect injected already");
    }
}

