/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.log.collect.config;

import com.ovopark.log.collect.aop.LogArgsAspect;
import com.ovopark.log.collect.aop.SpringScheduledTaskAop;
import com.ovopark.log.collect.config.UncollectibleArgsCheck;
import com.ovopark.log.collect.config.XxlJobEnhanceInit;
import com.ovopark.log.collect.context.LogContext;
import com.ovopark.log.collect.filter.TraceableFilter;
import com.ovopark.log.collect.filter.WebInvokeTimeFilter;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"org.springframework.web.servlet.config.annotation.WebMvcConfigurer", "org.springframework.boot.web.servlet.FilterRegistrationBean"})
public class LogConfiguration {
    @Bean
    public FilterRegistrationBean<Filter> traceableFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new TraceableFilter());
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<Filter> invokeTimeFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new WebInvokeTimeFilter());
        registration.setOrder(-2147483638);
        return registration;
    }

    @Bean
    public LogArgsAspect logArgsAspect() {
        return LogContext.getWithArgs() ? new LogArgsAspect() : null;
    }

    @Bean
    public UncollectibleArgsCheck uncollectibleArgsCheck() {
        return LogContext.getWithArgs() ? new UncollectibleArgsCheck() : null;
    }

    @Bean
    public XxlJobEnhanceInit xxlJobEnhanceInit() {
        return new XxlJobEnhanceInit();
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringScheduledTaskAop.class})
    public SpringScheduledTaskAop springScheduledTaskAop() {
        return new SpringScheduledTaskAop();
    }
}

