/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.log.collect.config;

import com.ovopark.log.collect.annotation.UncollectibleArgs;
import com.ovopark.log.collect.context.LogContext;
import com.ovopark.log.collect.context.LogSpringContext;
import com.ovopark.log.collect.util.LogUtil;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class UncollectibleArgsCheck
implements SmartLifecycle {
    private static final Logger LOG = LogUtil.logger(UncollectibleArgsCheck.class);
    private boolean started = false;

    public void start() {
        ApplicationContext applicationContext = LogSpringContext.getApplicationContext();
        RequestMappingHandlerMapping mappingBean = (RequestMappingHandlerMapping)applicationContext.getBean(RequestMappingHandlerMapping.class);
        Map map = mappingBean.getHandlerMethods();
        map.forEach((info, handlerMethod) -> {
            PatternsRequestCondition condition;
            Method method = handlerMethod.getMethod();
            if (method.isAnnotationPresent(UncollectibleArgs.class) && (condition = info.getPatternsCondition()) != null) {
                Set patterns = condition.getPatterns();
                LOG.info("\u68c0\u6d4b\u5230\u4e0d\u91c7\u96c6\u53c2\u6570: " + patterns);
                LogContext.addUncollectibleUrl((Set)patterns);
            }
        });
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public boolean isRunning() {
        return this.started;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }
}

