/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.log.collect.filter;

import com.ovopark.log.collect.context.LogContext;
import com.ovopark.log.collect.model.RpcTrace;
import com.ovopark.log.collect.rpc.LogRpcHandler;
import com.ovopark.log.collect.util.LogUtil;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TraceableFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        try {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String traceId = request.getHeader("dc-log-trace-id");
            String spanId = request.getHeader("dc-log-span-id");
            String uri = request.getRequestURI();
            RpcTrace rpcTrace = new RpcTrace().setUri(uri).setSpanId(spanId).setTraceId(traceId);
            LogRpcHandler.processProviderSide((RpcTrace)rpcTrace);
            response.addHeader("dc-log-trace-id", traceId);
            filterChain.doFilter(servletRequest, servletResponse);
            LogContext.removeAllThreadLocal();
        }
        catch (Exception e) {
            LogUtil.SNEAKY_EXCEPTION_LOG.error(this.getClass().getName(), (Throwable)e);
        }
    }

    public void destroy() {
    }
}

