/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.log.collect.filter;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.ovopark.log.collect.context.LogContext;
import com.ovopark.log.collect.context.LogSpringContext;
import com.ovopark.log.collect.util.LogUtil;
import com.ovopark.log.collect.util.NetUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class WebInvokeTimeFilter
implements Filter {
    private static final TransmittableThreadLocal<Long> INVOKE_TIME_TL = new TransmittableThreadLocal();

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        INVOKE_TIME_TL.set((Object)System.currentTimeMillis());
        filterChain.doFilter(request, response);
        long invokeTime = System.currentTimeMillis() - (Long)INVOKE_TIME_TL.get();
        LogUtil.INVOKE_TIME_LOG.info("{\"invokeTime\":" + invokeTime + ",\"uri\":\"" + LogContext.getUri() + "\",\"serverIp\":\"" + NetUtil.getHostIp() + "\",\"traceId\":\"" + LogContext.getTraceId() + "\",\"appName\":\"" + LogSpringContext.getAppName() + "\",\"port\":" + LogSpringContext.getPort() + ",\"spanId\":\"" + LogContext.getSpanId() + "\",\"threadName\":\"" + Thread.currentThread().getName() + "\",\"dtTime\":" + INVOKE_TIME_TL.get() + ",\"active\":\"" + LogSpringContext.getActive() + "\"}");
        INVOKE_TIME_TL.remove();
    }

    public void destroy() {
    }
}

