/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.log.collect.logging;

import com.ovopark.log.collect.logging.ILogging;
import com.ovopark.log.collect.logging.Log4J2Logging;
import com.ovopark.log.collect.logging.LogBackLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcLogging {
    private static final Logger LOGGER = LoggerFactory.getLogger(DcLogging.class);
    private ILogging iLogging;
    private boolean isLogback = false;

    private DcLogging() {
        try {
            Class.forName("ch.qos.logback.classic.Logger");
            this.iLogging = new LogBackLogging();
            this.isLogback = true;
        }
        catch (ClassNotFoundException e) {
            this.iLogging = new Log4J2Logging();
        }
    }

    public static DcLogging getInstance() {
        return DcLoggingInstance.INSTANCE;
    }

    public void loadConfiguration() {
        try {
            this.iLogging.loadConfiguration();
        }
        catch (Throwable t) {
            if (this.isLogback) {
                LOGGER.warn("Load Logback Configuration of Nacos fail, message: {}", (Object)t.getMessage());
            }
            LOGGER.warn("Load Log4j Configuration of Nacos fail, message: {}", (Object)t.getMessage());
        }
    }

    private static class DcLoggingInstance {
        private static final DcLogging INSTANCE = new DcLogging();

        private DcLoggingInstance() {
        }
    }
}

