/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.i18hub.sdk.client.api;

import com.ovopark.i18hub.sdk.client.api.I18PushProvider;
import com.ovopark.i18hub.sdk.client.api.I18PushTransport;
import com.ovopark.i18hub.sdk.client.api.ModuleContext;
import com.ovopark.i18hub.sdk.model.FileVer;
import com.ovopark.i18hub.sdk.model.I18PushRequest;
import com.ovopark.i18hub.sdk.model.I18PushResponse;
import com.ovopark.i18hub.sdk.model.LocaleContextModel;
import com.ovopark.i18hub.sdk.model.ModuleContextModel;
import com.ovopark.kernel.shared.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class I18Provider
implements I18PushProvider {
    private static final Logger log = LoggerFactory.getLogger(I18Provider.class);
    final Map<String, ModuleContextImpl> moduleContextMap = new LinkedHashMap<String, ModuleContextImpl>();
    final AtomicBoolean fixed = new AtomicBoolean(false);
    static I18Provider DEFAULT = new I18Provider();
    static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, Util.newThreadFactory((String)"i18-push"));

    I18Provider() {
    }

    @Override
    public ModuleContext messagehub() {
        return this.messagehub("base");
    }

    @Override
    public ModuleContext messagehub(String moduleVer) {
        return this.module("msg", moduleVer);
    }

    @Override
    public ModuleContext iohub() {
        return this.iohub("base");
    }

    @Override
    public ModuleContext iohub(String moduleVer) {
        return this.module("iohub", moduleVer);
    }

    @Override
    public ModuleContext log() {
        return this.log("base");
    }

    @Override
    public ModuleContext log(String moduleVer) {
        return this.module("log", moduleVer);
    }

    @Override
    public I18PushProvider.I18Pusher fixed() {
        if (this.fixed.compareAndSet(false, true)) {
            return new I18PushProvider.I18Pusher(){
                final AtomicBoolean submitted = new AtomicBoolean(false);

                @Override
                public void asyncSend(final I18PushTransport i18PushTransport) {
                    if (this.submitted.compareAndSet(false, true)) {
                        Util.schedule((ScheduledExecutorService)scheduledExecutorService, (Util.CatchRunnable)new Util.CatchRunnable(){
                            I18PushRequest i18PushRequest;

                            public void run() throws Exception {
                                I18PushResponse i18PushResponse;
                                if (this.i18PushRequest == null) {
                                    I18PushRequest i18PushRequest = new I18PushRequest();
                                    i18PushRequest.setVersion(3);
                                    i18PushRequest.setMinVersion(2);
                                    i18PushRequest.setNode(FileVer.UUID_STR);
                                    ArrayList<ModuleContextModel> moduleContextModelList = new ArrayList<ModuleContextModel>();
                                    for (ModuleContextImpl moduleContext : I18Provider.this.moduleContextMap.values()) {
                                        ModuleContextModel moduleContextModel = new ModuleContextModel();
                                        moduleContextModel.setModule(moduleContext.module);
                                        moduleContextModel.setModuleVer(moduleContext.moduleVer);
                                        ArrayList<LocaleContextModel> localeContextList = new ArrayList<LocaleContextModel>();
                                        for (LocaleContextModel localeContextModel : moduleContext.localeContextModelMap.values()) {
                                            localeContextList.add(localeContextModel);
                                        }
                                        moduleContextModel.setLocaleContextList(localeContextList);
                                        moduleContextModelList.add(moduleContextModel);
                                    }
                                    i18PushRequest.setModuleContextModelList(moduleContextModelList);
                                    this.i18PushRequest = i18PushRequest;
                                }
                                if ((i18PushResponse = i18PushTransport.request(this.i18PushRequest)) == null || !i18PushResponse.isSuccess()) {
                                    log.error("cannot push to i18server ");
                                }
                            }
                        }, (long)5L, (TimeUnit)TimeUnit.SECONDS, throwable -> true, () -> true);
                    }
                }

                @Override
                public I18PushResponse syncSend(I18PushTransport i18PushTransport) {
                    if (this.submitted.compareAndSet(false, true)) {
                        I18PushRequest i18PushRequest = new I18PushRequest();
                        i18PushRequest.setVersion(3);
                        i18PushRequest.setMinVersion(2);
                        i18PushRequest.setNode(FileVer.UUID_STR);
                        ArrayList<ModuleContextModel> moduleContextModelList = new ArrayList<ModuleContextModel>();
                        for (ModuleContextImpl moduleContext : I18Provider.this.moduleContextMap.values()) {
                            ModuleContextModel moduleContextModel = new ModuleContextModel();
                            moduleContextModel.setModule(moduleContext.module);
                            moduleContextModel.setModuleVer(moduleContext.moduleVer);
                            ArrayList<LocaleContextModel> localeContextList = new ArrayList<LocaleContextModel>();
                            for (LocaleContextModel localeContextModel : moduleContext.localeContextModelMap.values()) {
                                localeContextList.add(localeContextModel);
                            }
                            moduleContextModel.setLocaleContextList(localeContextList);
                            moduleContextModelList.add(moduleContextModel);
                        }
                        i18PushRequest.setModuleContextModelList(moduleContextModelList);
                        I18PushResponse i18PushResponse = i18PushTransport.request(i18PushRequest);
                        if (i18PushResponse == null || !i18PushResponse.isSuccess()) {
                            log.error("cannot push to i18server ");
                        }
                        return i18PushResponse;
                    }
                    return null;
                }
            };
        }
        throw new IllegalStateException(" call the function more than once???");
    }

    ModuleContext module(final String module, final String moduleVer) {
        String k = module + ":" + moduleVer;
        ModuleContextImpl moduleContext = this.moduleContextMap.computeIfAbsent(k, new Function<String, ModuleContextImpl>(){

            @Override
            public ModuleContextImpl apply(String s) {
                ModuleContextImpl mc = new ModuleContextImpl(I18Provider.this);
                mc.setModule(module);
                mc.setModuleVer(moduleVer);
                return mc;
            }
        });
        return moduleContext;
    }

    static class ModuleContextImpl
    implements ModuleContext {
        private String module;
        private String moduleVer;
        private Map<Locale, LocaleContextModel> localeContextModelMap = new LinkedHashMap<Locale, LocaleContextModel>();
        final I18PushProvider i18PushProvider;

        public ModuleContextImpl(I18PushProvider i18PushProvider) {
            this.i18PushProvider = i18PushProvider;
        }

        @Override
        public ModuleContext push(Locale locale, Map<String, String> entryList) {
            LocaleContextModel localeContextModel = this.getOrCreated0(locale);
            localeContextModel.getEntryList().putAll(entryList);
            return this;
        }

        private LocaleContextModel getOrCreated0(Locale locale) {
            LocaleContextModel localeContextModel = this.localeContextModelMap.computeIfAbsent(locale, new Function<Locale, LocaleContextModel>(){

                @Override
                public LocaleContextModel apply(Locale locale) {
                    LocaleContextModel localeContextModel = new LocaleContextModel();
                    localeContextModel.setLocale(locale);
                    return localeContextModel;
                }
            });
            return localeContextModel;
        }

        @Override
        public ModuleContext push(Locale locale, String i18Properties) {
            try (BufferedReader bufferedReader = new BufferedReader(new StringReader(i18Properties));){
                String line = bufferedReader.readLine();
                while (line != null) {
                    if (Util.isEmpty((CharSequence)line)) continue;
                    String[] kv = line.split("=");
                    this.push(locale, kv[0].trim(), kv[1]);
                    line = bufferedReader.readLine();
                }
            }
            catch (IOException e) {
                throw Util.convert2RuntimeException((Throwable)e);
            }
            return this;
        }

        @Override
        public ModuleContext push(Locale locale, String k, String v) {
            LocaleContextModel localeContextModel = this.getOrCreated0(locale);
            localeContextModel.getEntryList().put(k, v);
            return this;
        }

        @Override
        public I18PushProvider ok() {
            return this.i18PushProvider;
        }

        public String getModule() {
            return this.module;
        }

        public String getModuleVer() {
            return this.moduleVer;
        }

        public Map<Locale, LocaleContextModel> getLocaleContextModelMap() {
            return this.localeContextModelMap;
        }

        public I18PushProvider getI18PushProvider() {
            return this.i18PushProvider;
        }

        public void setModule(String module) {
            this.module = module;
        }

        public void setModuleVer(String moduleVer) {
            this.moduleVer = moduleVer;
        }

        public void setLocaleContextModelMap(Map<Locale, LocaleContextModel> localeContextModelMap) {
            this.localeContextModelMap = localeContextModelMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModuleContextImpl)) {
                return false;
            }
            ModuleContextImpl other = (ModuleContextImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$module = this.getModule();
            String other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            String this$moduleVer = this.getModuleVer();
            String other$moduleVer = other.getModuleVer();
            if (this$moduleVer == null ? other$moduleVer != null : !this$moduleVer.equals(other$moduleVer)) {
                return false;
            }
            Map<Locale, LocaleContextModel> this$localeContextModelMap = this.getLocaleContextModelMap();
            Map<Locale, LocaleContextModel> other$localeContextModelMap = other.getLocaleContextModelMap();
            if (this$localeContextModelMap == null ? other$localeContextModelMap != null : !((Object)this$localeContextModelMap).equals(other$localeContextModelMap)) {
                return false;
            }
            I18PushProvider this$i18PushProvider = this.getI18PushProvider();
            I18PushProvider other$i18PushProvider = other.getI18PushProvider();
            return !(this$i18PushProvider == null ? other$i18PushProvider != null : !this$i18PushProvider.equals(other$i18PushProvider));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModuleContextImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            String $moduleVer = this.getModuleVer();
            result = result * 59 + ($moduleVer == null ? 43 : $moduleVer.hashCode());
            Map<Locale, LocaleContextModel> $localeContextModelMap = this.getLocaleContextModelMap();
            result = result * 59 + ($localeContextModelMap == null ? 43 : ((Object)$localeContextModelMap).hashCode());
            I18PushProvider $i18PushProvider = this.getI18PushProvider();
            result = result * 59 + ($i18PushProvider == null ? 43 : $i18PushProvider.hashCode());
            return result;
        }

        public String toString() {
            return "I18Provider.ModuleContextImpl(module=" + this.getModule() + ", moduleVer=" + this.getModuleVer() + ", localeContextModelMap=" + this.getLocaleContextModelMap() + ", i18PushProvider=" + this.getI18PushProvider() + ")";
        }
    }
}

