/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.i18hub.sdk.client;

import com.ovopark.i18hub.sdk.client.ClientNodeProvider;
import com.ovopark.i18hub.sdk.client.DynamicMessageSource;
import com.ovopark.i18hub.sdk.client.I18ModuleDef;
import com.ovopark.i18hub.sdk.client.Link2I18Transport;
import com.ovopark.i18hub.sdk.model.AppLang;
import com.ovopark.i18hub.sdk.model.I18PullRequest;
import com.ovopark.i18hub.sdk.model.I18PullResponse;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.SharedLocale;
import java.io.ByteArrayInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.ResourceBundleMessageSource;

class SimpleDynamicMessageSource
extends ResourceBundleMessageSource
implements InitializingBean,
DynamicMessageSource {
    private static final Logger log = LoggerFactory.getLogger(SimpleDynamicMessageSource.class);
    public static final int refreshTimeSec = Config.ConfigPriority.option().getInt("i18hub.client.module.refreshTimeSec", Integer.valueOf(5));
    final boolean verbose = Config.ConfigPriority.option().getBoolean("i18hub.client.verbose", Boolean.valueOf(false)) != false || Config.ConfigPriority.option().getBoolean("I18HUB_CLIENT_VERBOSE", Boolean.valueOf(false)) != false;
    @Value(value="${spring.application.name}")
    private String app;
    private final Map<Locale, PropertiesFile> propertiesFileMap = new ConcurrentHashMap<Locale, PropertiesFile>();
    final I18ModuleDef i18ModuleDef;
    final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    final Link2I18Transport link2I18Transport;
    final ClientNodeProvider clientNodeProvider;

    public SimpleDynamicMessageSource(I18ModuleDef i18ModuleDef, Link2I18Transport link2I18Transport, ClientNodeProvider clientNodeProvider) {
        this.i18ModuleDef = i18ModuleDef;
        this.link2I18Transport = link2I18Transport;
        this.clientNodeProvider = clientNodeProvider;
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        PropertiesFile.KeyHolder found;
        if (!this.i18ModuleDef.remoteFetchEnabled()) {
            return super.resolveCodeWithoutArguments(code, locale);
        }
        PropertiesFile propertiesFile = this.propertiesFileMap.get(locale);
        if (propertiesFile != null && (found = (PropertiesFile.KeyHolder)propertiesFile.i18KeyMap.get(code)) != null) {
            return found.message;
        }
        return super.resolveCodeWithoutArguments(code, locale);
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        PropertiesFile.KeyHolder found;
        if (!this.i18ModuleDef.remoteFetchEnabled()) {
            return super.resolveCode(code, locale);
        }
        PropertiesFile propertiesFile = this.propertiesFileMap.get(locale);
        if (propertiesFile != null && (found = (PropertiesFile.KeyHolder)propertiesFile.i18KeyMap.get(code)) != null) {
            return found.messageFormat;
        }
        return super.resolveCode(code, locale);
    }

    synchronized void refresh(String module, String ver, Locale locale, Properties properties, String md5) {
        if (this.sameMD5If(locale, md5)) {
            return;
        }
        this.refresh0(module, ver, locale, () -> properties, md5);
    }

    private void refresh0(String module, String ver, Locale locale, Supplier<Properties> propertiesSupplier, String md5) {
        PropertiesFile propertiesFile = new PropertiesFile(md5);
        try {
            propertiesSupplier.get().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, c) -> {
                try {
                    propertiesFile.i18KeyMap.put((String)k, new PropertiesFile.KeyHolder((String)c, locale));
                }
                catch (Exception e) {
                    log.error(k + " = " + c);
                    log.error(e.getMessage(), (Throwable)e);
                }
            }));
            this.propertiesFileMap.put(locale, propertiesFile);
            log.info("load i18 properties: " + module + ":" + ver + ":" + locale + ", " + md5);
        }
        catch (Exception e) {
            log.error(e.getMessage() + ", " + locale, (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    private boolean sameMD5If(Locale locale, String md5) {
        PropertiesFile propertiesFile = this.propertiesFileMap.get(locale);
        if (propertiesFile != null) {
            return propertiesFile.md5.equals(md5);
        }
        return false;
    }

    synchronized void refresh(String module, String ver, Locale locale, String fileContent, String md5) {
        try {
            if (this.sameMD5If(locale, md5)) {
                return;
            }
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(Util.utf8((String)fileContent)));
            this.refresh0(module, ver, locale, () -> properties, md5);
        }
        catch (Exception e) {
            log.error(e.getMessage() + ", " + locale, (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.setBasenames(new String[]{"i18n/" + this.i18ModuleDef.module() + "/" + this.i18ModuleDef.moduleVer() + "/" + this.i18ModuleDef.moduleVer(), "i18n/" + this.i18ModuleDef.module() + "/base/base"});
        this.setDefaultEncoding("utf-8");
        this.setUseCodeAsDefaultMessage(this.i18ModuleDef.useCodeAsDefaultMessage());
        this.setDefaultLocale(this.i18ModuleDef.defaultLocale());
        log.info("remoteFetchEnabled: " + this.i18ModuleDef.remoteFetchEnabled());
        Util.schedule((ScheduledExecutorService)this.scheduledExecutorService, (Util.CatchRunnable)new Util.CatchRunnable(){

            public void run() throws Exception {
                if (!SimpleDynamicMessageSource.this.i18ModuleDef.remoteFetchEnabled()) {
                    return;
                }
                I18PullRequest i18PullRequest = new I18PullRequest();
                i18PullRequest.setVersion(3);
                i18PullRequest.setMinVersion(2);
                i18PullRequest.setApp(SimpleDynamicMessageSource.this.app);
                i18PullRequest.setNode(SimpleDynamicMessageSource.this.clientNodeProvider.clientNode().node());
                i18PullRequest.setIp(SimpleDynamicMessageSource.this.clientNodeProvider.clientNode().ip());
                i18PullRequest.setPort(SimpleDynamicMessageSource.this.clientNodeProvider.clientNode().port());
                i18PullRequest.setModule(SimpleDynamicMessageSource.this.i18ModuleDef.module());
                i18PullRequest.setModuleVer(Util.isEmpty((CharSequence)SimpleDynamicMessageSource.this.i18ModuleDef.moduleVer()) ? "base" : SimpleDynamicMessageSource.this.i18ModuleDef.moduleVer());
                ArrayList<AppLang> appLangList = new ArrayList<AppLang>();
                for (Locale locale : SharedLocale.activeLocaleList()) {
                    AppLang appLang = new AppLang();
                    appLang.setLocale(locale);
                    PropertiesFile propertiesFile = (PropertiesFile)SimpleDynamicMessageSource.this.propertiesFileMap.get(locale);
                    appLang.setMd5(propertiesFile == null ? null : propertiesFile.md5);
                    appLang.setLoadTimeMs(propertiesFile == null ? 0L : propertiesFile.loadTimeMs);
                    appLangList.add(appLang);
                }
                i18PullRequest.setAppLangList(appLangList);
                I18PullResponse i18PullResponse = SimpleDynamicMessageSource.this.link2I18Transport.request(i18PullRequest);
                if (i18PullResponse.isSuccess() && Util.isNotEmpty((Collection)i18PullResponse.getAppLangList())) {
                    for (AppLang appLang : i18PullResponse.getAppLangList()) {
                        try {
                            SimpleDynamicMessageSource.this.refresh(i18PullRequest.getModule(), i18PullRequest.getModuleVer(), appLang.getLocale(), appLang.getContent(), appLang.getMd5());
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }, (long)refreshTimeSec, (TimeUnit)TimeUnit.SECONDS, t -> {
            if (this.verbose) {
                log.warn(t.getMessage());
            }
            return true;
        }, () -> true);
    }

    static class PropertiesFile {
        private final String md5;
        private final long loadTimeMs;
        private final Map<String, KeyHolder> i18KeyMap = new ConcurrentHashMap<String, KeyHolder>();

        public PropertiesFile(String md5) {
            this.md5 = md5;
            this.loadTimeMs = System.currentTimeMillis();
        }

        public String getMd5() {
            return this.md5;
        }

        public long getLoadTimeMs() {
            return this.loadTimeMs;
        }

        public Map<String, KeyHolder> getI18KeyMap() {
            return this.i18KeyMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertiesFile)) {
                return false;
            }
            PropertiesFile other = (PropertiesFile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLoadTimeMs() != other.getLoadTimeMs()) {
                return false;
            }
            String this$md5 = this.getMd5();
            String other$md5 = other.getMd5();
            if (this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5)) {
                return false;
            }
            Map<String, KeyHolder> this$i18KeyMap = this.getI18KeyMap();
            Map<String, KeyHolder> other$i18KeyMap = other.getI18KeyMap();
            return !(this$i18KeyMap == null ? other$i18KeyMap != null : !((Object)this$i18KeyMap).equals(other$i18KeyMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertiesFile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $loadTimeMs = this.getLoadTimeMs();
            result = result * 59 + (int)($loadTimeMs >>> 32 ^ $loadTimeMs);
            String $md5 = this.getMd5();
            result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
            Map<String, KeyHolder> $i18KeyMap = this.getI18KeyMap();
            result = result * 59 + ($i18KeyMap == null ? 43 : ((Object)$i18KeyMap).hashCode());
            return result;
        }

        public String toString() {
            return "SimpleDynamicMessageSource.PropertiesFile(md5=" + this.getMd5() + ", loadTimeMs=" + this.getLoadTimeMs() + ", i18KeyMap=" + this.getI18KeyMap() + ")";
        }

        static class KeyHolder {
            private final String message;
            private final MessageFormat messageFormat;

            public KeyHolder(String message, Locale locale) {
                this.message = message;
                this.messageFormat = new MessageFormat(message, locale);
            }

            public String getMessage() {
                return this.message;
            }

            public MessageFormat getMessageFormat() {
                return this.messageFormat;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KeyHolder)) {
                    return false;
                }
                KeyHolder other = (KeyHolder)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                    return false;
                }
                MessageFormat this$messageFormat = this.getMessageFormat();
                MessageFormat other$messageFormat = other.getMessageFormat();
                return !(this$messageFormat == null ? other$messageFormat != null : !((Object)this$messageFormat).equals(other$messageFormat));
            }

            protected boolean canEqual(Object other) {
                return other instanceof KeyHolder;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                MessageFormat $messageFormat = this.getMessageFormat();
                result = result * 59 + ($messageFormat == null ? 43 : ((Object)$messageFormat).hashCode());
                return result;
            }

            public String toString() {
                return "SimpleDynamicMessageSource.PropertiesFile.KeyHolder(message=" + this.getMessage() + ", messageFormat=" + this.getMessageFormat() + ")";
            }
        }
    }
}

