/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.CollectionUtils;

public class ExcelUtils {
    public static boolean createWorkBook(String excelType, String sheetName, List<String> headList, List<List<String>> dataList, String path) {
        Object wb = null;
        wb = excelType == null || excelType.endsWith("2007") ? new XSSFWorkbook() : (excelType.endsWith("2003") ? new HSSFWorkbook() : new HSSFWorkbook());
        CreationHelper createHelper = wb.getCreationHelper();
        Sheet sheet = wb.createSheet(sheetName != null ? sheetName : "new sheet");
        Font headFont = wb.createFont();
        headFont.setFontHeightInPoints((short)14);
        headFont.setFontName("Courier New");
        headFont.setItalic(false);
        headFont.setStrikeout(false);
        CellStyle headStyle = wb.createCellStyle();
        CellStyle dataStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        dataStyle.setDataFormat(dataFormat.getFormat("@"));
        Row headRow = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            Cell cell = headRow.createCell(i);
            cell.setCellValue(createHelper.createRichTextString(headList.get(i)));
            cell.setCellStyle(headStyle);
        }
        int rowIndex = 1;
        for (List list : dataList) {
            Row row = sheet.createRow(rowIndex++);
            for (int j = 0; j < list.size(); ++j) {
                Cell cell = row.createCell(j);
                cell.setCellStyle(dataStyle);
                cell.setCellType(1);
                cell.setCellValue(createHelper.createRichTextString((String)list.get(j)));
            }
        }
        CellStyle textStyle = wb.createCellStyle();
        DataFormat dataFormat2 = wb.createDataFormat();
        textStyle.setDataFormat(dataFormat2.getFormat("@"));
        for (int i = 0; i < headList.size(); ++i) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 17 / 10);
            sheet.setDefaultColumnStyle(i, textStyle);
        }
        File file = new File(path);
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            boolean ismk = parentFile.mkdirs();
            System.out.println("\u521b\u5efa\u6587\u4ef6\u7684\u7ed3\u679c:" + ismk);
        }
        try (FileOutputStream fileOut = new FileOutputStream(path);){
            wb.write((OutputStream)fileOut);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createWorkBook(HttpServletResponse response, String excelType, String sheetName, List<String> headList, List<List<String>> dataList) throws IOException {
        response.setContentType("application/binary;charset=UTF-8");
        response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(StringUtils.isBlank((String)sheetName) ? "" : sheetName.replace(" ", "") + ".xls", "utf-8"));
        ServletOutputStream outputStream = response.getOutputStream();
        Object wb = null;
        wb = excelType == null || excelType.endsWith("2007") ? new XSSFWorkbook() : (excelType.endsWith("2003") ? new HSSFWorkbook() : new HSSFWorkbook());
        CreationHelper createHelper = wb.getCreationHelper();
        Sheet sheet = wb.createSheet(sheetName != null ? sheetName : "new sheet");
        Font headFont = wb.createFont();
        headFont.setFontHeightInPoints((short)14);
        headFont.setFontName("Courier New");
        headFont.setItalic(false);
        headFont.setStrikeout(false);
        CellStyle headStyle = wb.createCellStyle();
        CellStyle dataStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        dataStyle.setDataFormat(dataFormat.getFormat("@"));
        Row headRow = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            Cell cell = headRow.createCell(i);
            cell.setCellValue(createHelper.createRichTextString(headList.get(i)));
            cell.setCellStyle(headStyle);
        }
        int rowIndex = 1;
        for (List list : dataList) {
            Row row = sheet.createRow(rowIndex++);
            for (int j = 0; j < list.size(); ++j) {
                Cell cell = row.createCell(j);
                cell.setCellValue(createHelper.createRichTextString((String)list.get(j)));
            }
        }
        CellStyle textStyle = wb.createCellStyle();
        DataFormat dataFormat2 = wb.createDataFormat();
        textStyle.setDataFormat(dataFormat2.getFormat("@"));
        try {
            wb.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            outputStream.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createLinkWorkBook(HttpServletResponse response, String excelType, String sheetName, List<String> headList, List<List<String>> dataList, List<Integer> linkCellList) throws IOException {
        response.setContentType("application/binary;charset=UTF-8");
        response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(StringUtils.isBlank((String)sheetName) ? "" : sheetName.replace(" ", "") + ".xls", "utf-8"));
        ServletOutputStream outputStream = response.getOutputStream();
        Object wb = null;
        wb = excelType == null || excelType.endsWith("2007") ? new XSSFWorkbook() : (excelType.endsWith("2003") ? new HSSFWorkbook() : new HSSFWorkbook());
        CreationHelper createHelper = wb.getCreationHelper();
        Sheet sheet = wb.createSheet(sheetName != null ? sheetName : "new sheet");
        Font headFont = wb.createFont();
        headFont.setFontHeightInPoints((short)14);
        headFont.setFontName("Courier New");
        headFont.setItalic(false);
        headFont.setStrikeout(false);
        CellStyle headStyle = wb.createCellStyle();
        CellStyle dataStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        dataStyle.setDataFormat(dataFormat.getFormat("@"));
        Row headRow = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            Cell cell = headRow.createCell(i);
            cell.setCellValue(createHelper.createRichTextString(headList.get(i)));
            cell.setCellStyle(headStyle);
        }
        CellStyle hlinkStyle = wb.createCellStyle();
        Font hlinkFont = wb.createFont();
        hlinkFont.setUnderline((byte)1);
        hlinkFont.setFontHeightInPoints((short)12);
        hlinkFont.setColor(IndexedColors.BLUE.getIndex());
        hlinkStyle.setAlignment((short)2);
        hlinkStyle.setBorderBottom((short)1);
        hlinkStyle.setBorderLeft((short)1);
        hlinkStyle.setBorderTop((short)1);
        hlinkStyle.setBorderRight((short)1);
        hlinkStyle.setFont(hlinkFont);
        Boolean linkEmptyFlag = false;
        if (!CollectionUtils.isEmpty(linkCellList)) {
            linkEmptyFlag = true;
        }
        int rowIndex = 1;
        for (List<String> rowdata : dataList) {
            Row row = sheet.createRow(rowIndex++);
            for (int j = 0; j < rowdata.size(); ++j) {
                Cell cell = row.createCell(j);
                if (linkEmptyFlag.booleanValue() && linkCellList.contains(j)) {
                    cell.setCellStyle(hlinkStyle);
                } else {
                    cell.setCellStyle(dataStyle);
                }
                cell.setCellType(1);
                cell.setCellValue(createHelper.createRichTextString(rowdata.get(j)));
            }
        }
        CellStyle textStyle = wb.createCellStyle();
        DataFormat textFormat = wb.createDataFormat();
        textStyle.setDataFormat(textFormat.getFormat("@"));
        for (int i = 0; i < headList.size(); ++i) {
            sheet.autoSizeColumn(i);
            sheet.setDefaultColumnStyle(i, textStyle);
        }
        try {
            wb.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            outputStream.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createLinkWorkBookForExpandExport(HttpServletResponse response, String excelType, String sheetName, List<String> headList, List<List<String>> dataList, List<Integer> linkCellList, Integer newline) throws IOException {
        response.setContentType("application/binary;charset=UTF-8");
        response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(StringUtils.isBlank((String)sheetName) ? "" : sheetName.replace(" ", "") + ".xls", "utf-8"));
        ServletOutputStream outputStream = response.getOutputStream();
        Object wb = null;
        wb = excelType == null || excelType.endsWith("2007") ? new XSSFWorkbook() : (excelType.endsWith("2003") ? new HSSFWorkbook() : new HSSFWorkbook());
        CreationHelper createHelper = wb.getCreationHelper();
        Sheet sheet = wb.createSheet(sheetName != null ? sheetName : "new sheet");
        Font headFont = wb.createFont();
        headFont.setFontHeightInPoints((short)14);
        headFont.setFontName("Courier New");
        headFont.setItalic(false);
        headFont.setStrikeout(false);
        CellStyle headStyle = wb.createCellStyle();
        CellStyle dataStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        dataStyle.setDataFormat(dataFormat.getFormat("@"));
        Row headRow = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            Cell cell = headRow.createCell(i);
            cell.setCellValue(createHelper.createRichTextString(headList.get(i)));
            cell.setCellStyle(headStyle);
        }
        CellStyle hlinkStyle = wb.createCellStyle();
        Font hlinkFont = wb.createFont();
        hlinkFont.setUnderline((byte)1);
        hlinkFont.setFontHeightInPoints((short)12);
        hlinkFont.setColor(IndexedColors.BLUE.getIndex());
        hlinkStyle.setAlignment((short)2);
        hlinkStyle.setBorderBottom((short)1);
        hlinkStyle.setBorderLeft((short)1);
        hlinkStyle.setBorderTop((short)1);
        hlinkStyle.setBorderRight((short)1);
        hlinkStyle.setFont(hlinkFont);
        hlinkStyle.setWrapText(true);
        Boolean linkEmptyFlag = false;
        if (!CollectionUtils.isEmpty(linkCellList)) {
            linkEmptyFlag = true;
        }
        int rowIndex = 1;
        for (List<String> rowdata : dataList) {
            Row row = sheet.createRow(rowIndex++);
            for (int j = 0; j < rowdata.size(); ++j) {
                Cell cell = row.createCell(j);
                cell.setCellType(1);
                if (linkEmptyFlag.booleanValue() && linkCellList.contains(j)) {
                    String s = rowdata.get(j);
                    String[] linkArr = s.split(",");
                    String url = linkArr[0];
                    Hyperlink link = createHelper.createHyperlink(HyperlinkType.URL);
                    link.setAddress(url);
                    cell.setHyperlink(link);
                    cell.setCellStyle(hlinkStyle);
                    String ns = s.replaceAll(",", "\n");
                    cell.setCellStyle(hlinkStyle);
                    cell.setCellValue(createHelper.createRichTextString(ns));
                    continue;
                }
                cell.setCellStyle(dataStyle);
                cell.setCellValue(createHelper.createRichTextString(rowdata.get(j)));
            }
        }
        CellStyle textStyle = wb.createCellStyle();
        DataFormat textFormat = wb.createDataFormat();
        textStyle.setDataFormat(textFormat.getFormat("@"));
        for (int i = 0; i < headList.size(); ++i) {
            sheet.autoSizeColumn(i);
            sheet.setDefaultColumnStyle(i, textStyle);
        }
        try {
            wb.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            outputStream.close();
        }
        return true;
    }
}

