/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.model.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum InspectionTaskStatusEnum {
    DEFAULT(0, "\u9ed8\u8ba4"),
    AUDIT(1, "\u5f85\u5ba1\u6838"),
    REFUSE(2, "\u88ab\u9a73\u56de"),
    PASS(3, "\u5ba1\u6838\u901a\u8fc7"),
    INSPECT(4, "\u5de1\u5e97\u4e2d"),
    FINISH(5, "\u5df2\u5b8c\u6210"),
    EXPIRE(6, "\u5df2\u8fc7\u671f");

    private Integer code;
    private String desc;

    private InspectionTaskStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static InspectionTaskStatusEnum formatOrNull(Integer code) {
        InspectionTaskStatusEnum[] enums;
        if (null == code) {
            return null;
        }
        for (InspectionTaskStatusEnum enu : enums = InspectionTaskStatusEnum.values()) {
            if (!enu.getCode().equals(code)) continue;
            return enu;
        }
        return null;
    }

    public static InspectionTaskStatusEnum format(Integer code) {
        InspectionTaskStatusEnum se = InspectionTaskStatusEnum.formatOrNull(code);
        return null == se ? DEFAULT : se;
    }

    public static List<Integer> canotUpdate() {
        List<InspectionTaskStatusEnum> list = Arrays.asList(PASS, INSPECT, EXPIRE, FINISH);
        List<Integer> sortTitle = list.stream().map(InspectionTaskStatusEnum::getCode).collect(Collectors.toList());
        return sortTitle;
    }
}

