/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    private static final Logger logger = LoggerFactory.getLogger(IpUtils.class);
    private static String serverIp;

    public static String getRequestIpAddress(HttpServletRequest request) {
        String[] p;
        if (request == null) {
            return "";
        }
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if ((p = ip.split("[,]", 10)).length == 0) {
            return ip;
        }
        if (p.length == 1) {
            return p[0];
        }
        if ("unknown".equalsIgnoreCase(p[0])) {
            return p[1];
        }
        return p[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getServerIpAddress() {
        if (null != serverIp) return serverIp;
        Class<IpUtils> clazz = IpUtils.class;
        synchronized (IpUtils.class) {
            if (null != serverIp) return serverIp;
            serverIp = IpUtils.getIpAddress();
            // ** MonitorExit[var0] (shouldn't be in output)
            return serverIp;
        }
    }

    private static String getMacAddress() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            byte[] mac = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp() || (mac = netInterface.getHardwareAddress()) == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                if (sb.length() <= 0) continue;
                return sb.toString();
            }
        }
        catch (Exception e) {
            logger.error("MAC\u5730\u5740\u83b7\u53d6\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        return "";
    }

    private static String getIpAddress() {
        String preIp = "";
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    String lip = ip.getHostAddress().substring(ip.getHostAddress().lastIndexOf("."));
                    if (!"0".equals(lip) && "1".equals(lip)) {
                        return ip.getHostAddress();
                    }
                    if ("127.0.0.1".equals(ip.getHostAddress())) continue;
                    preIp = ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            logger.error("IP\u5730\u5740\u83b7\u53d6\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        return preIp;
    }

    public static boolean isInnerIP(String ip) {
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return false;
        }
        if (ip.equals("127.0.0.1") || ip.equals("0:0:0:0:0:0:0:1")) {
            return true;
        }
        String pattern = "((192\\.168|172\\.([1][6-9]|[2]\\d|3[01]))(\\.([2][0-4]\\d|[2][5][0-5]|[01]?\\d?\\d)){2}|^(\\D)*10(\\.([2][0-4]\\d|[2][5][0-5]|[01]?\\d?\\d)){3})";
        Pattern reg = Pattern.compile(pattern);
        Matcher match = reg.matcher(ip);
        return match.find();
    }
}

