/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.ovopark.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClazzConverterUtils {
    public static <T1, T2> T1 converterClass(T2 srcClazz, Class<T1> dstClazz) {
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON(srcClazz);
        return (T1)(jsonObject == null ? null : JSONObject.toJavaObject((JSON)jsonObject, dstClazz));
    }

    public static <T1, T2> T1 converterClass(T2 srcClazz, TypeReference<T1> type) {
        String json = JsonUtils.toJson(srcClazz);
        return json == null ? null : (T1)JsonUtils.fromJson(json, type);
    }

    public static <T1, T2> List<T1> converterClass(Collection<T2> srcClazzCollection, Class<T1> dstClazz) {
        JSONArray jsonArray = (JSONArray)JSONObject.toJSON(srcClazzCollection);
        return jsonArray == null ? new ArrayList() : JSONArray.parseArray((String)jsonArray.toJSONString(), dstClazz);
    }

    public static <T1, T2> T1[] converterClass(T2[] srcClazzArray, Class<T1> dstClazz) {
        JSONArray jsonArray = (JSONArray)JSONObject.toJSON(srcClazzArray);
        if (jsonArray == null) {
            return null;
        }
        List result = JSONArray.parseArray((String)jsonArray.toJSONString(), dstClazz);
        return result == null ? null : result.toArray();
    }
}

