/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().readTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).connectTimeout(1L, TimeUnit.SECONDS).hostnameVerifier(HttpUtils.getHostnameVerifier()).sslSocketFactory(HttpUtils.getSSLSocketFactory(), HttpUtils.getTrustManager()).build();
    private static final String DEFAULT_ENCODE_TYPE = "UTF-8";
    public static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostToOtherServer(String url, Map<String, Object> params) throws IOException {
        String result = "";
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName(DEFAULT_ENCODE_TYPE)));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity);
                log.info("result = " + result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGetToOtherServer(String url) throws IOException {
        String result = "";
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpPost = new HttpGet(url);
            httpPost.setHeader("Content-type", "application/json; charset=utf-8");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        return result;
    }

    public static String sendJsonToOtherServer(String url, Object data) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString((Object)data), Charset.forName(DEFAULT_ENCODE_TYPE)));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String sendGet(String url) {
        return HttpUtils.sendGet(url, null, null);
    }

    public static String sendGet(String url, Map<String, String> params) {
        return HttpUtils.sendGet(url, params, null);
    }

    public static String sendGet(String url, Map<String, String> params, Map<String, String> headers) {
        return HttpUtils.http(GET, url, params, null, null, headers);
    }

    public static String sendPost(String url, Map<String, String> datas) {
        return HttpUtils.http(POST, url, null, datas, null, null);
    }

    public static String sendPost(String url, Map<String, String> params, Map<String, String> datas) {
        return HttpUtils.http(POST, url, params, datas, null, null);
    }

    public static String sendPost(String url, Map<String, String> params, String jsonBody) {
        return HttpUtils.http(POST, url, params, null, jsonBody, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendJsonToOtherServerDefault(String url, Map<String, String> map) {
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(url);
        if (map != null && map.size() > 0) {
            NameValuePair[] nameValuePair = new NameValuePair[map.size()];
            int i = 0;
            for (String key : map.keySet()) {
                NameValuePair nameValuePairTmp;
                nameValuePair[i] = nameValuePairTmp = new NameValuePair();
                nameValuePair[i].setName(key);
                nameValuePair[i].setValue(map.get(key));
                ++i;
            }
            post.setRequestBody(nameValuePair);
        }
        post.getParams().setParameter("http.protocol.content-charset", (Object)DEFAULT_ENCODE_TYPE);
        HttpConnectionManagerParams managerParams = client.getHttpConnectionManager().getParams();
        managerParams.setConnectionTimeout(60000);
        managerParams.setSoTimeout(60000);
        try {
            int code = client.executeMethod((HttpMethod)post);
            if (code == 200) {
                String string = post.getResponseBodyAsString();
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    public static String sendPost(String url, Map<String, String> params, Map<String, String> datas, String jsonBody, Map<String, String> headers) {
        return HttpUtils.http(POST, url, params, datas, jsonBody, headers);
    }

    public static String sendPut(String url, Map<String, String> datas) {
        return HttpUtils.http(PUT, url, null, datas, null, null);
    }

    public static String sendPut(String url, Map<String, String> params, Map<String, String> datas) {
        return HttpUtils.http(PUT, url, params, datas, null, null);
    }

    public static String sendPut(String url, Map<String, String> params, String jsonBody) {
        return HttpUtils.http(PUT, url, params, null, jsonBody, null);
    }

    public static String sendPut(String url, Map<String, String> params, Map<String, String> datas, String jsonBody, Map<String, String> headers) {
        return HttpUtils.http(PUT, url, params, datas, jsonBody, headers);
    }

    public static String sendDelete(String url, Map<String, String> datas) {
        return HttpUtils.http(DELETE, url, null, datas, null, null);
    }

    public static String sendDelete(String url, Map<String, String> params, Map<String, String> datas) {
        return HttpUtils.http(DELETE, url, params, datas, null, null);
    }

    public static String sendDelete(String url, Map<String, String> params, String jsonBody) {
        return HttpUtils.http(DELETE, url, params, null, jsonBody, null);
    }

    public static String sendDelete(String url, Map<String, String> params, Map<String, String> datas, String jsonBody, Map<String, String> headers) {
        return HttpUtils.http(DELETE, url, params, datas, jsonBody, headers);
    }

    private static String http(String method, String url, Map<String, String> params, Map<String, String> datas, String jsonBody, Map<String, String> headers) {
        log.info(String.format("method:{} url:{} params:{} datas:{} jsonBody:{} headers:{}", method, url, null == params ? "" : JSON.toJSONString(params), null == datas ? "" : JSON.toJSONString(datas), null == jsonBody ? "" : jsonBody, null == headers ? "" : JSON.toJSONString(headers)));
        Request.Builder requestBuilder = null;
        if (null != params && params.size() > 0) {
            HttpUrl.Builder httpUrlBuilder = HttpUrl.parse((String)url).newBuilder();
            for (String string : params.keySet()) {
                httpUrlBuilder.addEncodedQueryParameter(string, params.get(string));
            }
            requestBuilder = new Request.Builder().url(httpUrlBuilder.build());
        } else {
            requestBuilder = new Request.Builder().url(url);
        }
        FormBody.Builder formBody = new FormBody.Builder();
        if (null != datas && datas.size() > 0) {
            for (String string : datas.keySet()) {
                formBody.add(string, datas.get(string));
            }
        }
        FormBody body = formBody.build();
        if (!StringUtils.isEmpty((CharSequence)jsonBody)) {
            body = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)jsonBody);
        }
        if (POST.equals(method)) {
            requestBuilder.post((RequestBody)body);
        } else if (PUT.equals(method)) {
            requestBuilder.put((RequestBody)body);
        } else if (DELETE.equals(method)) {
            requestBuilder.delete((RequestBody)body);
        }
        if (null != headers && headers.size() > 0) {
            for (String key : headers.keySet()) {
                requestBuilder.addHeader(key, headers.get(key));
            }
        }
        try {
            Long l = System.currentTimeMillis();
            Response response = httpClient.newCall(requestBuilder.build()).execute();
            Long time = System.currentTimeMillis() - l;
            if (response.isSuccessful()) {
                String result = response.body().string();
                log.info(String.format("url:{} time:{}ms statuscode:{} response_result:{}", url, time.toString(), response.code(), result));
                return result;
            }
            log.error(String.format("url:{} time:{}ms statuscode:{}", url, time.toString(), response.code()));
            return null;
        }
        catch (IOException iOException) {
            log.error(String.format("url:%s error: %s", url, iOException.getMessage()), (Throwable)iOException);
            return null;
        }
    }

    public static HostnameVerifier getHostnameVerifier() {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
        return hostnameVerifier;
    }

    public static SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{HttpUtils.getTrustManager()}, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static X509TrustManager getTrustManager() {
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        return trustManager;
    }
}

