/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.model.base;

import com.ovopark.constants.CommonConstants;
import com.ovopark.model.enums.DeleteEnum;
import com.ovopark.model.login.Users;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBase {
    private static final Logger logger = LoggerFactory.getLogger(EntityBase.class);

    public static void setCreateParams(Object object, Users user) {
        EntityBase.setCreateParams(object, user.getId());
    }

    public static void setCreateParams(Object object, Integer userId) {
        Method[] declaredMethods;
        Date now = new Date();
        Class<?> clazz = object.getClass();
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            try {
                if (method.getName().equals("setCreateId") || method.getName().equals("setUpdateId")) {
                    method.invoke(object, userId);
                    continue;
                }
                if (method.getName().equals("setCreateTime") || method.getName().equals("setUpdateTime")) {
                    method.invoke(object, now);
                    continue;
                }
                if (method.getName().equals("setIsDelete") || method.getName().equals("setDelFlag")) {
                    method.invoke(object, DeleteEnum.NOT_DELETED.getCode());
                    continue;
                }
                if (!method.getName().equals("setVersion")) continue;
                method.invoke(object, CommonConstants.DEFAULT_VERSION);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setUpdateParams(Object object, Users user) {
        Class<?> clazz = object.getClass();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        Date now = new Date();
        for (Method method : declaredMethods) {
            try {
                if (method.getName().equals("setCreateId") || method.getName().equals("setUpdateId")) {
                    method.invoke(object, user.getId());
                    continue;
                }
                if (!method.getName().equals("setUpdateTime")) continue;
                method.invoke(object, now);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static String getObjectId(Object object) {
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getDeclaredMethod("getId", new Class[0]);
            Object id = method.invoke(object, new Object[0]);
            if (null == id) {
                return "";
            }
            return id.toString();
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }
}

