/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.export.ExcelExportService;
import cn.hutool.core.util.ReflectUtil;
import com.ovopark.utils.MegUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    public static boolean createWorkBook(String excelType, String sheetName, List<String> headList, List<List<String>> dataList, String path) {
        Object wb = null;
        wb = excelType == null || excelType.endsWith("2007") ? new XSSFWorkbook() : (excelType.endsWith("2003") ? new HSSFWorkbook() : new HSSFWorkbook());
        CreationHelper createHelper = wb.getCreationHelper();
        Sheet sheet = wb.createSheet(sheetName != null ? sheetName : "new sheet");
        Font headFont = wb.createFont();
        headFont.setFontHeightInPoints((short)14);
        headFont.setFontName("Courier New");
        headFont.setItalic(false);
        headFont.setStrikeout(false);
        CellStyle headStyle = wb.createCellStyle();
        CellStyle dataStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        dataStyle.setDataFormat(dataFormat.getFormat("@"));
        Row headRow = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            Cell cell = headRow.createCell(i);
            cell.setCellValue(createHelper.createRichTextString(headList.get(i)));
            cell.setCellStyle(headStyle);
        }
        int rowIndex = 1;
        for (List list : dataList) {
            Row row = sheet.createRow(rowIndex++);
            for (int j = 0; j < list.size(); ++j) {
                Cell cell = row.createCell(j);
                cell.setCellStyle(dataStyle);
                cell.setCellType(1);
                cell.setCellValue(createHelper.createRichTextString((String)list.get(j)));
            }
        }
        CellStyle textStyle = wb.createCellStyle();
        DataFormat dataFormat2 = wb.createDataFormat();
        textStyle.setDataFormat(dataFormat2.getFormat("@"));
        for (int i = 0; i < headList.size(); ++i) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 17 / 10);
            sheet.setDefaultColumnStyle(i, textStyle);
        }
        File file = new File(path);
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            boolean ismk = parentFile.mkdirs();
            System.out.println("\u521b\u5efa\u6587\u4ef6\u7684\u7ed3\u679c:" + ismk);
        }
        try (FileOutputStream fileOut = new FileOutputStream(path);){
            wb.write((OutputStream)fileOut);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createWorkBook(HttpServletResponse response, String excelType, String sheetName, List<String> headList, List<List<String>> dataList) throws IOException {
        response.setContentType("application/binary;charset=UTF-8");
        response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(StringUtils.isBlank((String)sheetName) ? "" : sheetName.replace(" ", "") + ".xls", "utf-8"));
        ServletOutputStream outputStream = response.getOutputStream();
        Object wb = null;
        wb = excelType == null || excelType.endsWith("2007") ? new XSSFWorkbook() : (excelType.endsWith("2003") ? new HSSFWorkbook() : new HSSFWorkbook());
        CreationHelper createHelper = wb.getCreationHelper();
        Sheet sheet = wb.createSheet(sheetName != null ? sheetName : "new sheet");
        Font headFont = wb.createFont();
        headFont.setFontHeightInPoints((short)14);
        headFont.setFontName("Courier New");
        headFont.setItalic(false);
        headFont.setStrikeout(false);
        CellStyle headStyle = wb.createCellStyle();
        CellStyle dataStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        dataStyle.setDataFormat(dataFormat.getFormat("@"));
        Row headRow = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            Cell cell = headRow.createCell(i);
            cell.setCellValue(createHelper.createRichTextString(headList.get(i)));
            cell.setCellStyle(headStyle);
        }
        int rowIndex = 1;
        for (List list : dataList) {
            Row row = sheet.createRow(rowIndex++);
            for (int j = 0; j < list.size(); ++j) {
                Cell cell = row.createCell(j);
                cell.setCellValue(createHelper.createRichTextString((String)list.get(j)));
            }
        }
        CellStyle textStyle = wb.createCellStyle();
        DataFormat dataFormat2 = wb.createDataFormat();
        textStyle.setDataFormat(dataFormat2.getFormat("@"));
        try {
            wb.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            outputStream.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createLinkWorkBook(HttpServletResponse response, String excelType, String sheetName, List<String> headList, List<List<String>> dataList, List<Integer> linkCellList) throws IOException {
        response.setContentType("application/binary;charset=UTF-8");
        response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(StringUtils.isBlank((String)sheetName) ? "" : sheetName.replace(" ", "") + ".xls", "utf-8"));
        ServletOutputStream outputStream = response.getOutputStream();
        Object wb = null;
        wb = excelType == null || excelType.endsWith("2007") ? new XSSFWorkbook() : (excelType.endsWith("2003") ? new HSSFWorkbook() : new HSSFWorkbook());
        CreationHelper createHelper = wb.getCreationHelper();
        Sheet sheet = wb.createSheet(sheetName != null ? sheetName : "new sheet");
        Font headFont = wb.createFont();
        headFont.setFontHeightInPoints((short)14);
        headFont.setFontName("Courier New");
        headFont.setItalic(false);
        headFont.setStrikeout(false);
        CellStyle headStyle = wb.createCellStyle();
        CellStyle dataStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        dataStyle.setDataFormat(dataFormat.getFormat("@"));
        Row headRow = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            Cell cell = headRow.createCell(i);
            cell.setCellValue(createHelper.createRichTextString(headList.get(i)));
            cell.setCellStyle(headStyle);
        }
        CellStyle hlinkStyle = wb.createCellStyle();
        Font hlinkFont = wb.createFont();
        hlinkFont.setUnderline((byte)1);
        hlinkFont.setFontHeightInPoints((short)12);
        hlinkFont.setColor(IndexedColors.BLUE.getIndex());
        hlinkStyle.setAlignment((short)2);
        hlinkStyle.setBorderBottom((short)1);
        hlinkStyle.setBorderLeft((short)1);
        hlinkStyle.setBorderTop((short)1);
        hlinkStyle.setBorderRight((short)1);
        hlinkStyle.setFont(hlinkFont);
        Boolean linkEmptyFlag = false;
        if (!CollectionUtils.isEmpty(linkCellList)) {
            linkEmptyFlag = true;
        }
        int rowIndex = 1;
        for (List<String> rowdata : dataList) {
            Row row = sheet.createRow(rowIndex++);
            for (int j = 0; j < rowdata.size(); ++j) {
                Cell cell = row.createCell(j);
                if (linkEmptyFlag.booleanValue() && linkCellList.contains(j)) {
                    cell.setCellStyle(hlinkStyle);
                } else {
                    cell.setCellStyle(dataStyle);
                }
                cell.setCellType(1);
                cell.setCellValue(createHelper.createRichTextString(rowdata.get(j)));
            }
        }
        CellStyle textStyle = wb.createCellStyle();
        DataFormat textFormat = wb.createDataFormat();
        textStyle.setDataFormat(textFormat.getFormat("@"));
        for (int i = 0; i < headList.size(); ++i) {
            sheet.autoSizeColumn(i);
            sheet.setDefaultColumnStyle(i, textStyle);
        }
        try {
            wb.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            outputStream.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createLinkWorkBookForExpandExport(HttpServletResponse response, String excelType, String sheetName, List<String> headList, List<List<String>> dataList, List<Integer> linkCellList, Integer newline) throws IOException {
        response.setContentType("application/binary;charset=UTF-8");
        response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(StringUtils.isBlank((String)sheetName) ? "" : sheetName.replace(" ", "") + ".xls", "utf-8"));
        ServletOutputStream outputStream = response.getOutputStream();
        Object wb = null;
        wb = excelType == null || excelType.endsWith("2007") ? new XSSFWorkbook() : (excelType.endsWith("2003") ? new HSSFWorkbook() : new HSSFWorkbook());
        CreationHelper createHelper = wb.getCreationHelper();
        Sheet sheet = wb.createSheet(sheetName != null ? sheetName : "new sheet");
        Font headFont = wb.createFont();
        headFont.setFontHeightInPoints((short)14);
        headFont.setFontName("Courier New");
        headFont.setItalic(false);
        headFont.setStrikeout(false);
        CellStyle headStyle = wb.createCellStyle();
        CellStyle dataStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        dataStyle.setDataFormat(dataFormat.getFormat("@"));
        Row headRow = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            Cell cell = headRow.createCell(i);
            cell.setCellValue(createHelper.createRichTextString(headList.get(i)));
            cell.setCellStyle(headStyle);
        }
        CellStyle hlinkStyle = wb.createCellStyle();
        Font hlinkFont = wb.createFont();
        hlinkFont.setUnderline((byte)1);
        hlinkFont.setFontHeightInPoints((short)12);
        hlinkFont.setColor(IndexedColors.BLUE.getIndex());
        hlinkStyle.setAlignment((short)2);
        hlinkStyle.setBorderBottom((short)1);
        hlinkStyle.setBorderLeft((short)1);
        hlinkStyle.setBorderTop((short)1);
        hlinkStyle.setBorderRight((short)1);
        hlinkStyle.setFont(hlinkFont);
        hlinkStyle.setWrapText(true);
        Boolean linkEmptyFlag = false;
        if (!CollectionUtils.isEmpty(linkCellList)) {
            linkEmptyFlag = true;
        }
        int rowIndex = 1;
        for (List<String> rowdata : dataList) {
            Row row = sheet.createRow(rowIndex++);
            for (int j = 0; j < rowdata.size(); ++j) {
                Cell cell = row.createCell(j);
                cell.setCellType(1);
                if (linkEmptyFlag.booleanValue() && linkCellList.contains(j)) {
                    String s = rowdata.get(j);
                    String[] linkArr = s.split(",");
                    String url = linkArr[0];
                    Hyperlink link = createHelper.createHyperlink(HyperlinkType.URL);
                    link.setAddress(url);
                    cell.setHyperlink(link);
                    cell.setCellStyle(hlinkStyle);
                    String ns = s.replaceAll(",", "\n");
                    cell.setCellStyle(hlinkStyle);
                    cell.setCellValue(createHelper.createRichTextString(ns));
                    continue;
                }
                cell.setCellStyle(dataStyle);
                cell.setCellValue(createHelper.createRichTextString(rowdata.get(j)));
            }
        }
        CellStyle textStyle = wb.createCellStyle();
        DataFormat textFormat = wb.createDataFormat();
        textStyle.setDataFormat(textFormat.getFormat("@"));
        for (int i = 0; i < headList.size(); ++i) {
            sheet.autoSizeColumn(i);
            sheet.setDefaultColumnStyle(i, textStyle);
        }
        try {
            wb.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            outputStream.close();
        }
        return true;
    }

    public static <T> SXSSFWorkbook exportExcel(List<T> list, ExportParams exportParams, Class<T> pojoClass, Locale locale, Object[] excelNameObjArr, Object[] i18nObjArr) {
        return ExcelUtils.exportExcel(null, list, exportParams, pojoClass, locale, excelNameObjArr, i18nObjArr);
    }

    public static <T> SXSSFWorkbook exportExcel(String firstHead, List<T> list, ExportParams exportParams, Class<T> pojoClass, Locale locale, Object[] excelNameObjArr, Object[] i18nObjArr) {
        try {
            List<Object> colList = new ArrayList<ExcelExportEntity>();
            ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
            ExcelUtils.getExcelExportMap(colList, resList, list, pojoClass, locale, excelNameObjArr, i18nObjArr);
            colList = colList.stream().sorted(Comparator.comparing(ExcelExportEntity::getOrderNum)).collect(Collectors.toList());
            if (StringUtils.isNotEmpty((String)firstHead)) {
                ((ExcelExportEntity)colList.get(0)).setName(firstHead);
            }
            return ExcelUtils.exportExcel(exportParams, colList, resList);
        }
        catch (IllegalAccessException e) {
            log.error("exportExcel", (Throwable)e);
            return null;
        }
    }

    public static SXSSFWorkbook exportExcel(ExportParams entity, List<ExcelExportEntity> entityList, Collection<?> dataSet) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        ExcelUtils.resetCellMaxTextLength();
        new ExcelExportService().createSheetForMap((Workbook)workbook, entity, entityList, dataSet);
        return workbook;
    }

    public static void resetCellMaxTextLength() {
        SpreadsheetVersion excel2007 = SpreadsheetVersion.EXCEL2007;
        if (Integer.MAX_VALUE != excel2007.getMaxTextLength()) {
            try {
                Field field = excel2007.getClass().getDeclaredField("_maxTextLength");
                field.setAccessible(true);
                field.set(excel2007, Integer.MAX_VALUE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void getExcelExportMap(List<ExcelExportEntity> colList, List<Map<String, Object>> resList, List list, Class<?> pojoClass, Locale locale, Object[] excelNameObjArr, Object[] i18nObjArr) throws IllegalAccessException {
        Field[] classFields = ReflectUtil.getFields(pojoClass);
        ArrayList<Field> newFields = new ArrayList<Field>();
        for (Field field : classFields) {
            Excel excel = field.getAnnotation(Excel.class);
            if (excel == null) continue;
            ExcelExportEntity entity = new ExcelExportEntity();
            entity.setName(MegUtils.getMessage(Objects.nonNull(excelNameObjArr) ? MessageFormat.format(excel.name(), excelNameObjArr) : excel.name(), locale, (Object[])(Objects.nonNull(i18nObjArr) ? i18nObjArr : null)));
            entity.setWidth(excel.width());
            entity.setSuffix(Objects.nonNull(excelNameObjArr) ? MessageFormat.format(excel.suffix(), excelNameObjArr) : excel.suffix());
            entity.setKey((Object)field.getName());
            entity.setOrderNum(Integer.parseInt(excel.orderNum() == null ? "0" : excel.orderNum()));
            entity.setType(excel.type());
            colList.add(entity);
            newFields.add(field);
        }
        ExcelUtils.getDataList(resList, list, newFields);
    }

    private static void getDataList(List<Map<String, Object>> resList, List list, List<Field> newFields) throws IllegalAccessException {
        for (Object obj : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : newFields) {
                field.setAccessible(true);
                map.put(field.getName(), field.get(obj) != null ? field.get(obj) : "-");
            }
            resList.add(map);
        }
    }
}

