/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.context;

import com.ovopark.model.login.Users;
import com.ovopark.utils.IpUtils;
import com.ovopark.utils.UuidUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;

public class HttpContext {
    private static InheritableThreadLocal<HttpContextInfo> httpContextInfoThreadLocal = new InheritableThreadLocal();
    public static final String TRACE_ID_KEY = "_traceId";

    public static void start() {
        HttpContext.start(null, null);
    }

    public static void start(HttpServletRequest request, HttpServletResponse response) {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            httpContextInfoThreadLocal.set(new HttpContextInfo(request, response));
        } else {
            ((HttpContextInfo)httpContextInfoThreadLocal.get()).reset(request, response);
        }
    }

    public static HttpServletRequest getRequest() {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            return null;
        }
        return httpContextInfo.getRequest();
    }

    public static HttpServletResponse getResponse() {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            return null;
        }
        return httpContextInfo.getResponse();
    }

    public static String getIp() {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            return null;
        }
        return httpContextInfo.getIp();
    }

    public static void put(String key, Object obj) {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            return;
        }
        httpContextInfo.getData().put(key, obj);
    }

    public static Users getContextInfoUser() {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            return null;
        }
        return httpContextInfo.getUser();
    }

    public static void setContextInfoUser(Users user) {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            return;
        }
        httpContextInfo.setUser(user);
    }

    public static String getContextInfoToken() {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            return null;
        }
        return httpContextInfo.getToken();
    }

    public static void setContextInfoToken(String token) {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            return;
        }
        httpContextInfo.setToken(token);
    }

    public static Object get(String key) {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            return null;
        }
        return httpContextInfo.getData().getOrDefault(key, null);
    }

    public static Long getStartTime() {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            return null;
        }
        return httpContextInfo.getStartTime();
    }

    public static Long getEndTime() {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            return null;
        }
        return httpContextInfo.getEndTime();
    }

    public static String getTraceId() {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            return "";
        }
        return httpContextInfo.getTraceId();
    }

    public static Long finish() {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null == httpContextInfo) {
            return 0L;
        }
        httpContextInfo.setEndTime(System.currentTimeMillis());
        return httpContextInfo.getEndTime() - httpContextInfo.getStartTime();
    }

    public static Boolean isFinish() {
        HttpContextInfo httpContextInfo = (HttpContextInfo)httpContextInfoThreadLocal.get();
        if (null != httpContextInfo) {
            return httpContextInfo.getEndTime() > 0L;
        }
        return false;
    }

    private static class HttpContextInfo {
        private HttpServletRequest request;
        private HttpServletResponse response;
        private Long startTime;
        private Long endTime;
        private String traceId;
        private String ip;
        private Map<String, Object> data = new HashMap<String, Object>();
        private Users user;
        private String token;

        public HttpContextInfo(HttpServletRequest request, HttpServletResponse response) {
            this.reset(request, response);
        }

        public void reset(HttpServletRequest request, HttpServletResponse response) {
            String trace = null;
            if (null != request) {
                trace = request.getHeader(HttpContext.TRACE_ID_KEY);
                this.ip = IpUtils.getRequestIpAddress(request);
            } else {
                this.ip = "";
            }
            if (StringUtils.isEmpty((Object)trace)) {
                trace = IpUtils.getServerIpAddress() + "_" + UuidUtils.getUUID();
            }
            if (null != response) {
                response.setHeader(HttpContext.TRACE_ID_KEY, trace);
            }
            MDC.put((String)"sysTraceId", (String)trace);
            this.request = request;
            this.response = response;
            this.startTime = System.currentTimeMillis();
            this.endTime = 0L;
            this.traceId = trace;
            this.data.clear();
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public String getIp() {
            return this.ip;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public Users getUser() {
            return this.user;
        }

        public void setUser(Users user) {
            this.user = user;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }
    }
}

