/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);

    public static String toJson(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)JSON.parseObject((String)json, clazz);
        }
        catch (Exception ex) {
            logger.error("json decode error. json:" + json + ";class:" + clazz.getName());
            return null;
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> type) {
        try {
            return (T)JSON.parseObject((String)json, type, (Feature[])new Feature[0]);
        }
        catch (Exception ex) {
            logger.error("json decode error. json:" + json + ";type:" + type.getType().getTypeName());
            return null;
        }
    }

    public static <T> T fromJson(String json, Type type) {
        try {
            return (T)JSON.parseObject((String)json, (Type)type, (Feature[])new Feature[0]);
        }
        catch (Exception ex) {
            logger.error("json decode error. json:" + json + ";type:" + type.getTypeName());
            return null;
        }
    }

    static {
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    }
}

