/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import cn.hutool.core.io.FileUtil;
import com.aliyun.oss.OSSClient;
import com.google.common.io.Files;
import com.ovopark.utils.StorageClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;
import org.springframework.web.multipart.MultipartFile;

@Component
public class OssHelper {
    private static final Logger log = LoggerFactory.getLogger(OssHelper.class);
    @Value(value="${aliyun.oss.bucketName}")
    private String bucketName;
    @Value(value="${aliyun.oss.endpoint}")
    private String endpoint;
    @Value(value="${aliyun.accessKeyId}")
    private String accessKeyId;
    @Value(value="${aliyun.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${aliyun.oss.accessUrl}")
    private String accessUrl;
    @Resource
    private StorageClient client;

    public void deleteFile(String filePath) {
    }

    public byte[] downLoadIsNew(String imagePath) {
        try {
            return this.client.download(imagePath);
        }
        catch (Exception e) {
            log.warn("\u56fe\u7247\u672a\u627e\u5230{}", (Object)imagePath);
            return null;
        }
    }

    public void downLoadFileNew(String imagePath, String pathName) {
        try {
            byte[] img = this.client.download(imagePath);
            Files.write((byte[])img, (File)new File(pathName));
        }
        catch (Exception e) {
            log.warn("\u56fe\u7247\u672a\u627e\u5230{}", (Object)imagePath);
        }
    }

    public void putObject(File file, String imagePath) {
        try {
            this.client.upload(file, imagePath);
        }
        catch (Exception e) {
            log.error("\u9519\u8bef", (Throwable)e);
        }
    }

    public String putObject(byte[] data, String imagePath) {
        try {
            return this.client.upload(data, imagePath).getAccessUrl();
        }
        catch (Exception e) {
            log.error("\u9519\u8bef", (Throwable)e);
            return "";
        }
    }

    public String genImageName(String suffix) {
        String extName = suffix.substring(suffix.lastIndexOf("."));
        long millis = System.currentTimeMillis();
        Random random = new Random();
        int end3 = random.nextInt(999);
        String str = millis + String.format("%03d", end3);
        return str + extName;
    }

    public String getImagePath(String imageName) {
        long millis = System.currentTimeMillis();
        Random random = new Random();
        int end3 = random.nextInt(999);
        String str = millis + String.format("%03d", end3);
        return str + "/" + imageName;
    }

    public String uploadMultipartFile(MultipartFile file, String preFileName) {
        String imagePath = this.getImagePath(preFileName);
        return this.putMultipartObject(file, imagePath);
    }

    public String uploadMultipartFile(MultipartFile file, String preFileName, String fileName) {
        String imgName = this.genImageName(file.getOriginalFilename());
        String newFileName = "";
        newFileName = preFileName != null ? preFileName + "/" + imgName : imgName;
        String imagePath = this.getImagePath(newFileName);
        return this.putMultipartObject(file, imagePath);
    }

    public String uploadMultipartFile2(MultipartFile file, String preFileName, String fileName) {
        String imagePath = this.getImagePath(preFileName);
        log.info("preFileName==" + preFileName);
        log.info("imagePath==" + imagePath);
        return this.putMultipartObject(file, imagePath);
    }

    public String uploadFile(File file) {
        String newFileName = this.genImageName(file.getName());
        String imagePath = this.getImagePath(newFileName);
        this.putObject(file, imagePath);
        return imagePath;
    }

    public String uploadFile(String filePath, String key) throws Throwable {
        if (Objects.equals(this.client.getType(), "aliyun")) {
            OSSClient client = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
            client.putObject(this.bucketName, key, (InputStream)new FileInputStream(filePath));
            return this.accessUrl + "/" + key;
        }
        return this.client.upload(FileUtil.readBytes((String)filePath), key).getAccessUrl();
    }

    public String uploadFile(MultipartFile file, String preFileName) {
        String imgName = this.genImageName(file.getOriginalFilename());
        String newFileName = "";
        newFileName = preFileName != null ? preFileName + imgName : imgName;
        String imagePath = this.getImagePath(newFileName);
        return this.putMultipartObject(file, imagePath);
    }

    public List<String> uploadMultipartFiles(MultipartFile[] file, String preFileName) {
        ArrayList<String> list = new ArrayList<String>();
        for (MultipartFile multipartFile : file) {
            if (multipartFile == null) continue;
            String originalFilename = multipartFile.getOriginalFilename();
            log.info("originalFilename" + originalFilename);
            String fileName = this.genImageName(originalFilename);
            log.info("fileName" + fileName);
            String newFileName = fileName;
            if (preFileName != null) {
                newFileName = preFileName + newFileName;
            }
            log.info("newFileName" + newFileName);
            String imagePath = this.getImagePath(newFileName);
            log.info("imagePath" + imagePath);
            String url = this.putMultipartObject(multipartFile, imagePath);
            list.add(url);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String putMultipartObject(MultipartFile file, String imagePath) {
        try (InputStream inputStream = file.getInputStream();){
            if (Objects.equals(this.client.getType(), "aliyun")) {
                OSSClient client = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
                client.putObject(this.bucketName, imagePath, inputStream);
                String string2 = this.accessUrl + "/" + imagePath;
                return string2;
            }
            byte[] bytes = StreamUtils.copyToByteArray((InputStream)inputStream);
            String string = this.client.upload(bytes, imagePath).getAccessUrl();
            return string;
        }
        catch (Exception e) {
            log.error("\u56fe\u7247\u4e0a\u4f20\u9519\u8bef", (Throwable)e);
            return "";
        }
    }

    public List<String> sign(List<String> pathList) {
        return this.client.sign(pathList, 15552000L);
    }
}

