/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiUtil {
    private static final Logger log = LoggerFactory.getLogger(PoiUtil.class);
    public static final Integer PER_SHEET_ROW_COUNT = 1000000;
    public static final Integer PER_WRITE_ROW_COUNT = 2000;
    public static final Integer PER_SHEET_WRITE_COUNT = PER_SHEET_ROW_COUNT / PER_WRITE_ROW_COUNT;
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    public static String formatDate(Date date, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(date);
    }

    public static SXSSFWorkbook initExcel(Integer totalRowCount, String[] titles) {
        SXSSFWorkbook wb = new SXSSFWorkbook(100);
        Integer sheetCount = totalRowCount % PER_SHEET_ROW_COUNT == 0 ? totalRowCount / PER_SHEET_ROW_COUNT : totalRowCount / PER_SHEET_ROW_COUNT + 1;
        CellStyle style = PoiUtil.getCellStyle(wb);
        for (int i = 0; i < sheetCount; ++i) {
            SXSSFSheet sheet = wb.createSheet("sheet" + (i + 1));
            SXSSFRow headRow = sheet.createRow(0);
            for (int j = 0; j < titles.length; ++j) {
                SXSSFCell headRowCell = headRow.createCell(j);
                headRowCell.setCellValue(titles[j]);
                headRowCell.setCellStyle(style);
            }
        }
        return wb;
    }

    public static SXSSFWorkbook getWorkBook(String[] titles, String fileName) {
        SXSSFWorkbook wb = new SXSSFWorkbook(100);
        CellStyle style = PoiUtil.getCellStyle(wb);
        SXSSFSheet sheet = wb.createSheet(fileName);
        SXSSFRow headRow = sheet.createRow(0);
        for (int j = 0; j < titles.length; ++j) {
            SXSSFCell headRowCell = headRow.createCell(j);
            headRowCell.setCellValue(titles[j]);
            headRowCell.setCellStyle(style);
        }
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downLoadExcelToLocalPath(Workbook wb, String exportPath) {
        FileOutputStream fops = null;
        File file = new File(exportPath);
        try {
            if (!file.exists()) {
                boolean success = file.createNewFile();
                file.setWritable(true);
            }
            fops = new FileOutputStream(file);
            wb.write((OutputStream)fops);
        }
        catch (Exception e) {
            log.error("\u9519\u8bef", (Throwable)e);
        }
        finally {
            if (null != wb) {
                try {
                    wb.close();
                }
                catch (Exception e) {
                    log.error("\u9519\u8bef", (Throwable)e);
                }
            }
            if (null != fops) {
                try {
                    fops.close();
                }
                catch (Exception e) {
                    log.error("\u9519\u8bef", (Throwable)e);
                }
            }
        }
    }

    public static final CellStyle getStyle(SXSSFWorkbook wb, Short color) {
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        if (color != null) {
            Font font = wb.createFont();
            font.setColor(color.shortValue());
            style.setFont(font);
        }
        return style;
    }

    public static final CellStyle getFontStyle(SXSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)10);
        font.setFontName("Arial");
        style.setFont(font);
        return style;
    }

    public static CellStyle getCellStyle(SXSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setWrapText(true);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        return style;
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }

    public static boolean validateExcel(String filePath) {
        return filePath != null && (PoiUtil.isExcel2003(filePath) || PoiUtil.isExcel2007(filePath));
    }

    public static List<Row> getExcelRead(String fileName, InputStream is, boolean isTitle) throws Exception {
        Workbook workbook = PoiUtil.getWorkbook(fileName, is);
        Sheet sheet = workbook.getSheetAt(0);
        int count = 0;
        ArrayList<Row> list = new ArrayList<Row>();
        for (Row row : sheet) {
            if (count == 0 && isTitle) {
                ++count;
                continue;
            }
            if (row == null) continue;
            list.add(row);
        }
        return list;
    }

    public static Workbook getWorkbook(String fileName, InputStream is) throws Exception {
        Object workbook = null;
        boolean isExcel2003 = true;
        if (PoiUtil.isExcel2007(fileName)) {
            isExcel2003 = false;
        }
        workbook = isExcel2003 ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
        return workbook;
    }

    public static String getCellValue(Cell cell) {
        String cellValue = "";
        switch (cell.getCellType()) {
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    cellValue = sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue())).toString();
                    break;
                }
                DataFormatter dataFormatter = new DataFormatter();
                cellValue = dataFormatter.formatCellValue(cell);
                break;
            }
            case 1: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case 4: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            case 2: {
                cellValue = cell.getCellFormula() + "";
                break;
            }
            case 3: {
                cellValue = "";
                break;
            }
            case 5: {
                cellValue = "\u975e\u6cd5\u5b57\u7b26";
                break;
            }
            default: {
                cellValue = "\u672a\u77e5\u7c7b\u578b";
            }
        }
        return cellValue;
    }

    public static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            try {
                CellRangeAddress range = sheet.getMergedRegion(i);
                int firstColumn = range.getFirstColumn();
                int lastColumn = range.getLastColumn();
                int firstRow = range.getFirstRow();
                int lastRow = range.getLastRow();
                if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getMergedRegionValue_check(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            try {
                CellRangeAddress ca = sheet.getMergedRegion(i);
                int firstColumn = ca.getFirstColumn();
                int lastColumn = ca.getLastColumn();
                int firstRow = ca.getFirstRow();
                int lastRow = ca.getLastRow();
                if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
                Row fRow = sheet.getRow(firstRow);
                Cell fCell = fRow.getCell(firstColumn);
                return PoiUtil.getCellValue(fCell);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getCellValueAsJudge_check(Cell cell) {
        int column;
        int row;
        if (cell == null) {
            return "";
        }
        Sheet sheet = cell.getSheet();
        if (PoiUtil.isMergedRegion(sheet, row = cell.getRowIndex(), column = cell.getColumnIndex())) {
            return PoiUtil.getMergedRegionValue_check(sheet, row, column);
        }
        return PoiUtil.getCellValue(cell);
    }

    public static Map<Integer, List<PictureData>> getRowPictures(String fileName, InputStream is) throws Exception {
        return PoiUtil.getPictures(fileName, is, ClientAnchor::getRow1);
    }

    public static Map<Integer, List<PictureData>> getPictures(String fileName, InputStream is, ExtractPictureKey extractor) throws Exception {
        XSSFClientAnchor cAnchor;
        XSSFPicture picture;
        List list;
        XSSFDrawing drawingPatriarch;
        HashMap<Integer, List<PictureData>> map = new HashMap<Integer, List<PictureData>>();
        Workbook workbook = PoiUtil.getWorkbook(fileName, is);
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet instanceof XSSFSheet) {
            drawingPatriarch = ((XSSFSheet)sheet).getDrawingPatriarch();
            if (drawingPatriarch == null) {
                return map;
            }
            list = drawingPatriarch.getShapes();
            for (XSSFShape shape : list) {
                if (!(shape instanceof XSSFPicture)) continue;
                picture = (XSSFPicture)shape;
                cAnchor = (XSSFClientAnchor)picture.getAnchor();
                map.computeIfAbsent(extractor.extract((ClientAnchor)cAnchor), ArrayList::new).add(picture.getPictureData());
            }
        }
        if (sheet instanceof HSSFSheet) {
            drawingPatriarch = ((HSSFSheet)sheet).getDrawingPatriarch();
            if (drawingPatriarch == null) {
                return map;
            }
            list = drawingPatriarch.getChildren();
            for (XSSFShape shape : list) {
                if (!(shape instanceof HSSFPicture)) continue;
                picture = (HSSFPicture)shape;
                cAnchor = picture.getClientAnchor();
                map.computeIfAbsent(extractor.extract((ClientAnchor)cAnchor), ArrayList::new).add(picture.getPictureData());
            }
        }
        return map;
    }

    @FunctionalInterface
    static interface ExtractPictureKey {
        public int extract(ClientAnchor var1);
    }
}

