/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import cn.hutool.http.ContentType;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ovopark.utils.StorageObj;
import com.ovopark.utils.StorageResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StorageClient {
    private static final Logger log = LoggerFactory.getLogger(StorageClient.class);
    @Value(value="${storage.host}")
    private String host;
    @Value(value="${storage.type}")
    private String type;
    @Value(value="${storage.referer}")
    private String referer;

    public StorageObj upload(File file, String name) {
        HttpResponse response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(this.host + "/api/dc/storage/oss/upload")).header("storageType", this.type)).header("moduleId", "1")).form("file", file, name).execute();
        String body = response.body();
        if (!response.isOk()) {
            log.error(this.host, (Object)this.type);
            log.error(body);
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25" + body);
        }
        StorageResult res = (StorageResult)JSON.parseObject((String)body, (TypeReference)new TypeReference<StorageResult<StorageObj>>(){}, (Feature[])new Feature[0]);
        if (!res.isOk()) {
            log.info(body);
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25" + body);
        }
        return (StorageObj)res.getData();
    }

    public StorageObj upload(byte[] data, String name) {
        HttpResponse response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(this.host + "/api/dc/storage/oss/upload")).header("storageType", this.type)).header("moduleId", "1")).form("file", data, name).execute();
        String body = response.body();
        if (!response.isOk()) {
            log.error(this.host, (Object)this.type);
            log.error(body);
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25" + body);
        }
        StorageResult res = (StorageResult)JSON.parseObject((String)body, (TypeReference)new TypeReference<StorageResult<StorageObj>>(){}, (Feature[])new Feature[0]);
        if (!res.isOk()) {
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25" + body);
        }
        return (StorageObj)res.getData();
    }

    public byte[] download(String imagePath) {
        return ((HttpRequest)HttpUtil.createGet((String)imagePath).header("Referer", this.referer)).execute().bodyBytes();
    }

    public List<String> sign(List<String> pathList, Long duration) {
        if (!Objects.equals("aws", this.type)) {
            return pathList;
        }
        if (CollectionUtils.isEmpty(pathList)) {
            return pathList;
        }
        List mapList = pathList.stream().map(path -> {
            String[] split;
            log.info(path);
            if (StringUtils.isBlank((CharSequence)path)) {
                return null;
            }
            if (path.startsWith("http://")) {
                path = path.replace("http://", "");
            }
            if (path.startsWith("https://")) {
                path = path.replace("https://", "");
            }
            if ((split = path.split("/")).length < 2) {
                throw new RuntimeException("\u53c2\u6570\u9519\u8bef: path=" + path + "\u4e0d\u662f\u6709\u6548\u5730\u5740");
            }
            split[0] = null;
            path = Arrays.stream(split).filter(Objects::nonNull).collect(Collectors.joining("/"));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("path", (String)path);
            map.put("storageType", this.type);
            map.put("moduleId", "1");
            return map;
        }).collect(Collectors.toList());
        String body = JSON.toJSONString(mapList.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        log.info(body);
        HttpResponse response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(this.host + "/api/dc/storage/auth/v1/getExpiredToken/new?globalDuration=" + duration + "&globalTimeUnitId=2")).header("storageType", this.type)).header("moduleId", "1")).body(body, ContentType.JSON.getValue()).execute();
        body = response.body();
        log.info(body);
        if (!response.isOk()) {
            log.error(this.host, (Object)this.type);
            log.error(body);
            throw new RuntimeException("\u7b7e\u540d" + body);
        }
        pathList = (List)((StorageResult)JSON.parseObject((String)body, (TypeReference)new TypeReference<StorageResult<List<String>>>(){}, (Feature[])new Feature[0])).getData();
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = pathList.iterator();
        for (int i = 0; i < mapList.size(); ++i) {
            if (mapList.get(i) == null) {
                result.add(null);
                continue;
            }
            result.add((String)it.next());
        }
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public String getType() {
        return this.type;
    }

    public String getReferer() {
        return this.referer;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StorageClient)) {
            return false;
        }
        StorageClient other = (StorageClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$referer = this.getReferer();
        String other$referer = other.getReferer();
        return !(this$referer == null ? other$referer != null : !this$referer.equals(other$referer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StorageClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $referer = this.getReferer();
        result = result * 59 + ($referer == null ? 43 : $referer.hashCode());
        return result;
    }

    public String toString() {
        return "StorageClient(host=" + this.getHost() + ", type=" + this.getType() + ", referer=" + this.getReferer() + ")";
    }
}

