/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.model.enums;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public enum InspectionPlanMainTypeEnum {
    DISPLAY(0, "\u9648\u5217\u4e2d\u5fc3", "DISPLAY_CENTER"),
    INSPECTION(1, "\u5de1\u68c0\u8ba1\u5212", "INSPECTION_PLAN"),
    LIVE_PATROL(8, "\u73b0\u573a\u5de1\u5e97", "LIVE_CHECK_PLAN"),
    DEP_PATROL(7, "\u95e8\u5e97\u81ea\u68c0", "DEP_CHECK_PLAN"),
    REMOTE_PATROL(9, "\u8fdc\u7a0b\u5de1\u5e97", "REMOTE_CHECK_PLAN");

    private Integer code;
    private String desc;
    private String msgDesc;

    private InspectionPlanMainTypeEnum(Integer code, String desc, String msgDesc) {
        this.code = code;
        this.desc = desc;
        this.msgDesc = msgDesc;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getMsgDesc() {
        return this.msgDesc;
    }

    public static InspectionPlanMainTypeEnum formatOrNull(Integer code) {
        InspectionPlanMainTypeEnum[] enums;
        if (null == code) {
            return null;
        }
        for (InspectionPlanMainTypeEnum enu : enums = InspectionPlanMainTypeEnum.values()) {
            if (!enu.getCode().equals(code)) continue;
            return enu;
        }
        return null;
    }

    public static InspectionPlanMainTypeEnum format(Integer code) {
        InspectionPlanMainTypeEnum se = InspectionPlanMainTypeEnum.formatOrNull(code);
        return null == se ? DISPLAY : se;
    }

    public static List<String> getTitle() {
        InspectionPlanMainTypeEnum[] enums = InspectionPlanMainTypeEnum.values();
        List<InspectionPlanMainTypeEnum> list = Arrays.asList(enums);
        List<String> sortTitle = list.stream().sorted(Comparator.comparing(InspectionPlanMainTypeEnum::getCode)).map(InspectionPlanMainTypeEnum::getDesc).collect(Collectors.toList());
        return sortTitle;
    }

    public static String getMsgDescByCode(Integer code) {
        for (InspectionPlanMainTypeEnum type : InspectionPlanMainTypeEnum.values()) {
            if (!type.getCode().equals(code)) continue;
            String msgDesc = type.getMsgDesc();
            if (msgDesc != null && msgDesc.contains("_")) {
                return msgDesc.split("_")[0];
            }
            return msgDesc;
        }
        return null;
    }
}

