/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Integer zipFilePip(String zipPath, List<String> paths) {
        File zipfile = new File(zipPath);
        if (zipfile.exists()) {
            return 1;
        }
        try (WritableByteChannel out = Channels.newChannel(new FileOutputStream(zipPath));){
            long size = 0L;
            ArrayList<File> files = new ArrayList<File>();
            for (String path : paths) {
                File file = new File(path);
                size += file.length();
                files.add(file);
            }
            Pipe pipe = Pipe.open();
            CompletableFuture.runAsync(() -> FileUtils.runTask(pipe, files));
            Pipe.SourceChannel readableByteChannel = pipe.source();
            ByteBuffer buffer = ByteBuffer.allocate(10240);
            while (readableByteChannel.read(buffer) >= 0) {
                buffer.flip();
                out.write(buffer);
                buffer.clear();
            }
            Integer n = 1;
            return n;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 2;
        }
    }

    private static void runTask(Pipe pipe, List<File> files) {
        try (ZipOutputStream zos = new ZipOutputStream(Channels.newOutputStream(pipe.sink()));
             WritableByteChannel out = Channels.newChannel(zos);){
            System.out.println("Begin");
            for (File file : files) {
                System.out.println("start: " + file.getName());
                zos.putNextEntry(new ZipEntry(file.getName()));
                FileChannel jpgChannel = new FileInputStream(file).getChannel();
                jpgChannel.transferTo(0L, file.length(), out);
                jpgChannel.close();
                System.out.println("end: " + file.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

