/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.multipart.MultipartFile;

@Configuration
public class OssUtil {
    protected static final Logger log = LoggerFactory.getLogger(OssUtil.class);
    @Autowired
    private Environment env;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String endpoint;
    private static String bucketName;
    private static String accessUrl;
    private static String filedir;
    private String endDir = "/";

    @PostConstruct
    public void readConfig() {
        accessKeyId = this.env.getProperty("aliyun.oss.accessKeyId");
        accessKeySecret = this.env.getProperty("aliyun.oss.accessKeySecret");
        endpoint = this.env.getProperty("aliyun.oss.endpoint");
        bucketName = this.env.getProperty("aliyun.oss.bucketName");
        accessUrl = this.env.getProperty("aliyun.oss.accessUrl");
    }

    public String uploadImg2Oss(MultipartFile file, Long id) {
        if (file.getSize() > 0x1400000L) {
            return "\u56fe\u7247\u592a\u5927";
        }
        String originalFilename = file.getOriginalFilename();
        String substring = originalFilename.substring(originalFilename.lastIndexOf(".")).toLowerCase();
        Random random = new Random();
        String name = (long)random.nextInt(10000) + System.currentTimeMillis() + substring;
        try {
            InputStream inputStream = file.getInputStream();
            OssUtil.uploadFile2OSS(inputStream, name, id);
            return name;
        }
        catch (Exception e) {
            return "\u4e0a\u4f20\u5931\u8d25";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String uploadFile2OSS(InputStream instream, String fileName, Long id) {
        String ret = "";
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)instream.available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentType(OssUtil.getcontentType(fileName.substring(fileName.lastIndexOf("."))));
            objectMetadata.setContentDisposition("inline;filename=" + fileName);
            OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
            PutObjectResult putResult = ossClient.putObject(bucketName, filedir + fileName, instream, objectMetadata);
            ret = putResult.getETag();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (instream != null) {
                    instream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadExcel2OSS(InputStream instream, String fileName) {
        String ret = "";
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)instream.available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentType("application/vnd.ms-excel");
            objectMetadata.setContentDisposition("inline;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
            PutObjectResult putResult = ossClient.putObject(bucketName, filedir + fileName, instream, objectMetadata);
            ret = putResult.getETag();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (instream != null) {
                    instream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String key = filedir + fileName;
        return OssUtil.getUrl(key);
    }

    public static String getcontentType(String FilenameExtension) {
        if (FilenameExtension.equalsIgnoreCase(".bmp")) {
            return "image/bmp";
        }
        if (FilenameExtension.equalsIgnoreCase(".gif")) {
            return "image/gif";
        }
        if (FilenameExtension.equalsIgnoreCase(".jpeg") || FilenameExtension.equalsIgnoreCase(".jpg") || FilenameExtension.equalsIgnoreCase(".png")) {
            return "image/jpeg";
        }
        if (FilenameExtension.equalsIgnoreCase(".html")) {
            return "text/html";
        }
        if (FilenameExtension.equalsIgnoreCase(".txt")) {
            return "text/plain";
        }
        if (FilenameExtension.equalsIgnoreCase(".vsd")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.equalsIgnoreCase(".pptx") || FilenameExtension.equalsIgnoreCase(".ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equalsIgnoreCase(".docx") || FilenameExtension.equalsIgnoreCase(".doc")) {
            return "application/msword";
        }
        if (FilenameExtension.equalsIgnoreCase(".xml")) {
            return "text/xml";
        }
        return "image/jpeg";
    }

    public String getImgUrl(String fileUrl) {
        if (!StringUtils.isEmpty((CharSequence)fileUrl)) {
            String[] split = fileUrl.split("/");
            String url = OssUtil.getUrl(filedir + split[split.length - 1]);
            return url;
        }
        return null;
    }

    public static String getUrl(String key) {
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        Date expiration = new Date(new Date().getTime() + 315360000000L);
        URL url = ossClient.generatePresignedUrl(bucketName, key, expiration);
        if (url != null) {
            return url.toString();
        }
        return null;
    }

    public String checkList(List<MultipartFile> fileList, Long id) {
        String fileUrl = "";
        String str = "";
        String photoUrl = "";
        for (int i = 0; i < fileList.size(); ++i) {
            fileUrl = this.uploadImg2Oss(fileList.get(i), id);
            str = this.getImgUrl(fileUrl);
            photoUrl = i == 0 ? str : photoUrl + "," + str;
        }
        return photoUrl.trim();
    }

    public String checkImage(MultipartFile file, Long id) {
        String fileUrl = this.uploadImg2Oss(file, id);
        String str = this.getImgUrl(fileUrl);
        return str.trim();
    }

    public Environment getEnv() {
        return this.env;
    }

    public String getEndDir() {
        return this.endDir;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }

    public void setEndDir(String endDir) {
        this.endDir = endDir;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OssUtil)) {
            return false;
        }
        OssUtil other = (OssUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        String this$endDir = this.getEndDir();
        String other$endDir = other.getEndDir();
        return !(this$endDir == null ? other$endDir != null : !this$endDir.equals(other$endDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OssUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        String $endDir = this.getEndDir();
        result = result * 59 + ($endDir == null ? 43 : $endDir.hashCode());
        return result;
    }

    public String toString() {
        return "OssUtil(env=" + this.getEnv() + ", endDir=" + this.getEndDir() + ")";
    }

    static {
        filedir = "store-plan/";
    }
}

