/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import java.math.BigDecimal;

public class BigDecimalUtils {
    public static Integer DEFAULT_SCALE = 2;
    public static Integer DEFAULT_SCALE_FOUR = 4;
    public static Integer DEFAULT_SELF_DIVIDE = 1;
    public static Integer ZERO = 0;

    public static String calculatePercentStr(Integer targetCount, Integer totalCount, Integer scale, Integer roundMode) {
        BigDecimal target = new BigDecimal(targetCount);
        BigDecimal total = new BigDecimal(totalCount);
        if (scale == null) {
            scale = DEFAULT_SCALE;
        }
        if (roundMode == null) {
            roundMode = 4;
        }
        if (totalCount == null || ZERO.equals(totalCount)) {
            String zeroPercent = BigDecimal.ZERO.setScale(DEFAULT_SCALE).toString();
            StringBuffer sb = new StringBuffer(zeroPercent);
            zeroPercent = sb.append("%").toString();
            return zeroPercent;
        }
        BigDecimal divideNumber = target.divide(total, (int)scale, roundMode);
        BigDecimal multiply = divideNumber.multiply(new BigDecimal(100));
        String percent = multiply.setScale(DEFAULT_SCALE).toString();
        StringBuffer sb = new StringBuffer(percent);
        percent = sb.append("%").toString();
        return percent;
    }

    public static String calculateBigDecimalPercentStr(BigDecimal target, BigDecimal total, Integer scale, Integer roundMode) {
        if (scale == null) {
            scale = DEFAULT_SCALE;
        }
        if (roundMode == null) {
            roundMode = 4;
        }
        if (total == null || ZERO.equals(total)) {
            String zeroPercent = BigDecimal.ZERO.setScale(DEFAULT_SCALE).toString();
            StringBuffer sb = new StringBuffer(zeroPercent);
            zeroPercent = sb.append("%").toString();
            return zeroPercent;
        }
        BigDecimal divideNumber = target.divide(total, (int)scale, roundMode);
        BigDecimal multiply = divideNumber.multiply(new BigDecimal(100));
        String percent = multiply.setScale(DEFAULT_SCALE).toString();
        StringBuffer sb = new StringBuffer(percent);
        percent = sb.append("%").toString();
        return percent;
    }

    public static BigDecimal calculateBigDecimalPercent(BigDecimal target, BigDecimal total, Integer scale, Integer roundMode) {
        if (target.compareTo(total) == 0) {
            return new BigDecimal(100).setScale((int)scale, roundMode);
        }
        if (scale == null) {
            scale = DEFAULT_SCALE;
        }
        if (roundMode == null) {
            roundMode = 4;
        }
        if (total == null || ZERO.equals(total)) {
            BigDecimal result = total.setScale((int)scale, roundMode);
            return result;
        }
        return target.divide(total, (int)scale, roundMode);
    }

    public static BigDecimal calculatePercent(Integer targetCount, Integer totalCount, Integer scale, Integer roundMode) {
        if (targetCount.equals(totalCount)) {
            return new BigDecimal(100).setScale((int)scale, roundMode);
        }
        BigDecimal target = new BigDecimal(targetCount);
        BigDecimal total = new BigDecimal(totalCount);
        if (scale == null) {
            scale = DEFAULT_SCALE;
        }
        if (roundMode == null) {
            roundMode = 4;
        }
        if (totalCount == null || ZERO.equals(totalCount)) {
            BigDecimal result = total.setScale((int)scale, roundMode);
            return result;
        }
        return target.divide(total, (int)scale, roundMode).multiply(new BigDecimal(100));
    }

    public static BigDecimal calculatePercentMuti100(Integer targetCount, Integer totalCount, Integer scale, Integer roundMode) {
        BigDecimal target = new BigDecimal(targetCount);
        BigDecimal total = new BigDecimal(totalCount);
        if (scale == null) {
            scale = DEFAULT_SCALE;
        }
        if (roundMode == null) {
            roundMode = 4;
        }
        if (totalCount == null || ZERO.equals(totalCount)) {
            BigDecimal result = total.setScale((int)scale, roundMode);
            return result;
        }
        return target.divide(total, (int)scale, roundMode).multiply(new BigDecimal(100));
    }
}

