/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import com.alibaba.fastjson.JSON;
import com.ovopark.constants.CommonHttpConstants;
import com.ovopark.model.enums.TokenTypeEnum;
import java.io.IOException;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttp3Util {
    private static Logger logger = LoggerFactory.getLogger(OkHttp3Util.class);
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGet(String url, Map<String, String> param, String token, Integer tokenType, String scheme) {
        if (scheme == null) {
            scheme = SCHEME_HTTP;
        }
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new CommonParamInterceptor()).build();
        HttpUrl.Builder httpBuild = new HttpUrl.Builder().scheme(scheme).host(url);
        for (String key : param.keySet()) {
            httpBuild.addQueryParameter(key, param.get(key));
        }
        HttpUrl httpUrl = httpBuild.build();
        Request.Builder builder = new Request.Builder();
        TokenTypeEnum tokenTypeEnum = TokenTypeEnum.format(tokenType);
        Request request = builder.url(httpUrl).header(tokenTypeEnum.getDesc(), token).build();
        Call call = okHttpClient.newCall(request);
        try (Response response = call.execute();){
            String result = response.body().string();
            logger.info("url:" + url + "\u7684\u8fd4\u56de\u53c2\u6570:" + result);
            String string = result;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void doPostCallBack(String url, Map<String, Object> params, Callback callback) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new LoggerInterceptor()).build();
        RequestBody body = RequestBody.create((MediaType)JSON, (String)com.alibaba.fastjson.JSON.toJSONString(params));
        Request request = new Request.Builder().url(url).post(body).build();
        okHttpClient.newCall(request).enqueue(callback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String url, Map<String, Object> params, String token, Integer tokenType) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new LoggerInterceptor()).build();
        RequestBody body = RequestBody.create((MediaType)JSON, (String)com.alibaba.fastjson.JSON.toJSONString(params));
        TokenTypeEnum tokenTypeEnum = TokenTypeEnum.format(tokenType);
        Request request = new Request.Builder().url(url).post(body).header(tokenTypeEnum.getDesc(), token).build();
        try (Response response = okHttpClient.newCall(request).execute();){
            String result = response.body().string();
            logger.info("url:" + url + "\u7684\u8fd4\u56de\u53c2\u6570:" + result);
            String string = result;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class CommonParamInterceptor
    implements Interceptor {
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request oldRequest = chain.request();
            Response response = null;
            Request addParamRequest = this.addHeader(oldRequest);
            addParamRequest = this.addParam(oldRequest);
            response = chain.proceed(addParamRequest);
            return response;
        }

        private Request addParam(Request oldRequest) {
            Object builder = null;
            HttpUrl.Builder httpUrlBuilder = oldRequest.url().newBuilder();
            Map<String, String> commonParamMap = CommonHttpConstants.commonParamMap;
            for (String key : commonParamMap.keySet()) {
                httpUrlBuilder.addQueryParameter(key, commonParamMap.get(key));
            }
            HttpUrl build = httpUrlBuilder.build();
            Request newRequest = oldRequest.newBuilder().method(oldRequest.method(), oldRequest.body()).url(build).build();
            return newRequest;
        }

        public Request addHeader(Request oldRequest) {
            Request.Builder builder = oldRequest.newBuilder();
            Map<String, String> commonHeaderMap = CommonHttpConstants.commonHeaderMap;
            for (String key : commonHeaderMap.keySet()) {
                builder.addHeader(key, commonHeaderMap.get(key));
            }
            return builder.build();
        }
    }

    public static class LoggerInterceptor
    implements Interceptor {
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            long startTime = System.nanoTime();
            logger.info(String.format("Sending request %s on %s%n%s", request.url(), chain.connection(), request.headers()));
            Response response = chain.proceed(request);
            long endTime = System.nanoTime();
            logger.info(String.format("Received response for %s in %.1fms%n%s", response.request().url(), (double)(endTime - startTime) / 1000000.0, response.headers()));
            return response;
        }
    }
}

