/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.model.dto;

import com.ovopark.model.dto.DetailDto;
import com.ovopark.model.enums.MainTypeEnum;
import com.ovopark.model.req.CheckTemplateVoReq;
import com.ovopark.utils.ListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MainAndDesc {
    private Integer mainType;
    private String description;
    private List<CheckTemplateVoReq> templateVoList = new ArrayList<CheckTemplateVoReq>();

    public String getDetail(DetailDto detailDto) {
        if (detailDto != null && detailDto.getMainType().equals(this.getMainType())) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MainTypeEnum.formatOrNull(this.getMainType()).getDesc());
        return stringBuffer.toString();
    }

    public String getDetail() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MainTypeEnum.formatOrNull(this.getMainType()).getDesc());
        return stringBuffer.toString();
    }

    public String getDescAndTemDetail() {
        StringBuffer stringBuffer = new StringBuffer();
        if (CollectionUtils.isNotEmpty(this.templateVoList)) {
            stringBuffer.append("\u6a21\u677f\uff1a").append(this.templateVoList.stream().map(CheckTemplateVoReq::getTemplateName).collect(Collectors.joining(","))).append(";");
        }
        if (StringUtils.isNotBlank((String)this.description)) {
            stringBuffer.append("\u95ee\u9898\u63cf\u8ff0\uff1a").append(this.description).append(";");
        }
        return stringBuffer.toString();
    }

    public String getDescAndTemDetail(DetailDto detailDto, int i) {
        StringBuffer stringBuffer = new StringBuffer();
        if (CollectionUtils.isNotEmpty(this.templateVoList)) {
            if (detailDto != null && CollectionUtils.isNotEmpty(detailDto.getTemplateIds())) {
                String templateName;
                Map<Integer, List<CheckTemplateVoReq>> collect = this.templateVoList.stream().collect(Collectors.groupingBy(CheckTemplateVoReq::getTemplateId));
                boolean collectionsEqual = ListUtils.areCollectionsEqual(collect.keySet().stream().sorted().collect(Collectors.toList()), detailDto.getTemplateIds().stream().sorted().collect(Collectors.toList()));
                if (!collectionsEqual && StringUtils.isNotBlank((String)(templateName = this.templateVoList.stream().map(CheckTemplateVoReq::getTemplateName).collect(Collectors.joining(","))))) {
                    stringBuffer.append("\u6a21\u677f\uff1a").append(templateName).append(";");
                }
            } else {
                String templateName = this.templateVoList.stream().map(CheckTemplateVoReq::getTemplateName).collect(Collectors.joining(","));
                stringBuffer.append("\u6a21\u677f\uff1a").append(templateName).append(";");
            }
        } else if (i != 0 && CollectionUtils.isNotEmpty(detailDto.getTemplateIds())) {
            stringBuffer.append("\u6a21\u677f\u88ab\u5168\u90e8\u5220\u9664").append(";");
        }
        if (detailDto != null && !detailDto.getMainType().equals(this.getMainType())) {
            stringBuffer.append("\u68c0\u67e5\u65b9\u5f0f\uff1a").append(MainTypeEnum.formatOrNull(this.mainType).getDesc()).append(";");
        }
        if (StringUtils.isNotBlank((String)this.description)) {
            if (detailDto != null && (StringUtils.isBlank((String)detailDto.getDescription()) || !detailDto.getDescription().equals(this.description))) {
                stringBuffer.append("\u95ee\u9898\u63cf\u8ff0\uff1a").append(this.description).append(";");
            }
        } else if (i != 0 && detailDto != null && !StringUtils.isBlank((String)detailDto.getDescription())) {
            stringBuffer.append("\u95ee\u9898\u63cf\u8ff0\u88ab\u5220\u9664").append(";");
        }
        return stringBuffer.toString();
    }

    public static MainAndDescBuilder builder() {
        return new MainAndDescBuilder();
    }

    public Integer getMainType() {
        return this.mainType;
    }

    public String getDescription() {
        return this.description;
    }

    public List<CheckTemplateVoReq> getTemplateVoList() {
        return this.templateVoList;
    }

    public void setMainType(Integer mainType) {
        this.mainType = mainType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTemplateVoList(List<CheckTemplateVoReq> templateVoList) {
        this.templateVoList = templateVoList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MainAndDesc)) {
            return false;
        }
        MainAndDesc other = (MainAndDesc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$mainType = this.getMainType();
        Integer other$mainType = other.getMainType();
        if (this$mainType == null ? other$mainType != null : !((Object)this$mainType).equals(other$mainType)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<CheckTemplateVoReq> this$templateVoList = this.getTemplateVoList();
        List<CheckTemplateVoReq> other$templateVoList = other.getTemplateVoList();
        return !(this$templateVoList == null ? other$templateVoList != null : !((Object)this$templateVoList).equals(other$templateVoList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MainAndDesc;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $mainType = this.getMainType();
        result = result * 59 + ($mainType == null ? 43 : ((Object)$mainType).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<CheckTemplateVoReq> $templateVoList = this.getTemplateVoList();
        result = result * 59 + ($templateVoList == null ? 43 : ((Object)$templateVoList).hashCode());
        return result;
    }

    public String toString() {
        return "MainAndDesc(mainType=" + this.getMainType() + ", description=" + this.getDescription() + ", templateVoList=" + this.getTemplateVoList() + ")";
    }

    public MainAndDesc(Integer mainType, String description, List<CheckTemplateVoReq> templateVoList) {
        this.mainType = mainType;
        this.description = description;
        this.templateVoList = templateVoList;
    }

    public MainAndDesc() {
    }

    public static class MainAndDescBuilder {
        private Integer mainType;
        private String description;
        private List<CheckTemplateVoReq> templateVoList;

        MainAndDescBuilder() {
        }

        public MainAndDescBuilder mainType(Integer mainType) {
            this.mainType = mainType;
            return this;
        }

        public MainAndDescBuilder description(String description) {
            this.description = description;
            return this;
        }

        public MainAndDescBuilder templateVoList(List<CheckTemplateVoReq> templateVoList) {
            this.templateVoList = templateVoList;
            return this;
        }

        public MainAndDesc build() {
            return new MainAndDesc(this.mainType, this.description, this.templateVoList);
        }

        public String toString() {
            return "MainAndDesc.MainAndDescBuilder(mainType=" + this.mainType + ", description=" + this.description + ", templateVoList=" + this.templateVoList + ")";
        }
    }
}

