/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.model.dto.message;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.messagehub.sdk.model.ParamContext;
import com.ovopark.messagehub.sdk.model.ThirdMessage;
import com.ovopark.model.dto.message.BaseMessageDTO;
import com.ovopark.model.dto.message.TaskMessage;
import com.ovopark.model.enums.MainTypeEnum;
import com.ovopark.model.pojo.MsgToUserPojo;
import com.ovopark.utils.DateUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ThirdMessageDTO
extends BaseMessageDTO {
    private Integer userId;
    private Integer targetUserId;
    private String templateKey;
    private ParamContext content;
    private ParamContext title;
    private String groupId;
    private String type;
    private String roundId;
    private String auditDetailId;
    private Integer mainType;
    private MsgToUserPojo msgToUserPojo;
    private Date createTime;

    public ParamContext getContent() {
        return new ParamContext().plainText(JSONObject.toJSONString((Object)this.getTaskMessage()));
    }

    public Map<String, Object> getParam() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", this.msgToUserPojo.getType());
        if (this.msgToUserPojo.getSubId() != null) {
            param.put("taskId", this.msgToUserPojo.getSubId());
        }
        if (this.msgToUserPojo.getExecuteType() != null) {
            param.put("executeType", this.msgToUserPojo.getExecuteType());
        }
        if (this.msgToUserPojo.getDepId() != null) {
            param.put("deptId", this.msgToUserPojo.getDepId());
        }
        if (this.msgToUserPojo.getDeptName() != null) {
            param.put("deptName", this.msgToUserPojo.getDeptName());
        }
        if (this.msgToUserPojo.getRoundId() != null) {
            param.put("roundId", this.msgToUserPojo.getRoundId());
        }
        if (this.msgToUserPojo.getJsonText() != null) {
            param.put("checkType", 1);
        }
        if (this.msgToUserPojo.getAuditDetailId() != null) {
            param.put("auditDetailId", this.msgToUserPojo.getAuditDetailId());
        }
        param.put("newObjectType", MainTypeEnum.formatOrNull(this.msgToUserPojo.getMainType()).getMsgDesc());
        return param;
    }

    private TaskMessage getTaskMessage() {
        TaskMessage message = new TaskMessage();
        message.setContent(this.msgToUserPojo.getMessage());
        message.setCreateTime(DateUtil.format(new Date()));
        message.setEnterpriseId(this.msgToUserPojo.getGroupId());
        message.setSrcUserId(this.msgToUserPojo.getSrcUserId());
        message.setTargetUserId(this.msgToUserPojo.getUserId());
        message.setSubId(this.msgToUserPojo.getSubId());
        message.setObjectType(this.msgToUserPojo.getObjectType());
        message.setDescription(JSONObject.toJSONString(this.getParam()));
        message.setStatus(0);
        message.setCategory(this.msgToUserPojo.getCategory());
        return message;
    }

    public ThirdMessage getThirdMessage() {
        ThirdMessage thirdMessage = new ThirdMessage();
        thirdMessage.setTargetUserId(this.msgToUserPojo.getUserId());
        thirdMessage.setObjectType(this.msgToUserPojo.getObjectType());
        thirdMessage.setCategory(this.msgToUserPojo.getCategory());
        if (this.msgToUserPojo.getObjectId() != null) {
            thirdMessage.setObjectId(this.msgToUserPojo.getObjectId());
            thirdMessage.setObjectIds(String.valueOf(this.msgToUserPojo.getObjectId()));
        }
        thirdMessage.setMainType(this.msgToUserPojo.getMainType());
        thirdMessage.setSubId(this.msgToUserPojo.getSubId());
        thirdMessage.setEnterpriseId(this.msgToUserPojo.getGroupId());
        thirdMessage.setDescription(this.msgToUserPojo.getMessage());
        thirdMessage.setDetails(JSONObject.toJSONString(this.getParam()));
        thirdMessage.setJsonText(this.msgToUserPojo.getJsonText());
        return thirdMessage;
    }

    public static ThirdMessageDTOBuilder builder() {
        return new ThirdMessageDTOBuilder();
    }

    public Integer getUserId() {
        return this.userId;
    }

    public Integer getTargetUserId() {
        return this.targetUserId;
    }

    public String getTemplateKey() {
        return this.templateKey;
    }

    public ParamContext getTitle() {
        return this.title;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public String getType() {
        return this.type;
    }

    public String getRoundId() {
        return this.roundId;
    }

    public String getAuditDetailId() {
        return this.auditDetailId;
    }

    public Integer getMainType() {
        return this.mainType;
    }

    public MsgToUserPojo getMsgToUserPojo() {
        return this.msgToUserPojo;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public void setTargetUserId(Integer targetUserId) {
        this.targetUserId = targetUserId;
    }

    public void setTemplateKey(String templateKey) {
        this.templateKey = templateKey;
    }

    public void setContent(ParamContext content) {
        this.content = content;
    }

    public void setTitle(ParamContext title) {
        this.title = title;
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRoundId(String roundId) {
        this.roundId = roundId;
    }

    public void setAuditDetailId(String auditDetailId) {
        this.auditDetailId = auditDetailId;
    }

    public void setMainType(Integer mainType) {
        this.mainType = mainType;
    }

    public void setMsgToUserPojo(MsgToUserPojo msgToUserPojo) {
        this.msgToUserPojo = msgToUserPojo;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThirdMessageDTO)) {
            return false;
        }
        ThirdMessageDTO other = (ThirdMessageDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$userId = this.getUserId();
        Integer other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$targetUserId = this.getTargetUserId();
        Integer other$targetUserId = other.getTargetUserId();
        if (this$targetUserId == null ? other$targetUserId != null : !((Object)this$targetUserId).equals(other$targetUserId)) {
            return false;
        }
        String this$templateKey = this.getTemplateKey();
        String other$templateKey = other.getTemplateKey();
        if (this$templateKey == null ? other$templateKey != null : !this$templateKey.equals(other$templateKey)) {
            return false;
        }
        ParamContext this$content = this.getContent();
        ParamContext other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        ParamContext this$title = this.getTitle();
        ParamContext other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$roundId = this.getRoundId();
        String other$roundId = other.getRoundId();
        if (this$roundId == null ? other$roundId != null : !this$roundId.equals(other$roundId)) {
            return false;
        }
        String this$auditDetailId = this.getAuditDetailId();
        String other$auditDetailId = other.getAuditDetailId();
        if (this$auditDetailId == null ? other$auditDetailId != null : !this$auditDetailId.equals(other$auditDetailId)) {
            return false;
        }
        Integer this$mainType = this.getMainType();
        Integer other$mainType = other.getMainType();
        if (this$mainType == null ? other$mainType != null : !((Object)this$mainType).equals(other$mainType)) {
            return false;
        }
        MsgToUserPojo this$msgToUserPojo = this.getMsgToUserPojo();
        MsgToUserPojo other$msgToUserPojo = other.getMsgToUserPojo();
        if (this$msgToUserPojo == null ? other$msgToUserPojo != null : !((Object)this$msgToUserPojo).equals(other$msgToUserPojo)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ThirdMessageDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $targetUserId = this.getTargetUserId();
        result = result * 59 + ($targetUserId == null ? 43 : ((Object)$targetUserId).hashCode());
        String $templateKey = this.getTemplateKey();
        result = result * 59 + ($templateKey == null ? 43 : $templateKey.hashCode());
        ParamContext $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        ParamContext $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $roundId = this.getRoundId();
        result = result * 59 + ($roundId == null ? 43 : $roundId.hashCode());
        String $auditDetailId = this.getAuditDetailId();
        result = result * 59 + ($auditDetailId == null ? 43 : $auditDetailId.hashCode());
        Integer $mainType = this.getMainType();
        result = result * 59 + ($mainType == null ? 43 : ((Object)$mainType).hashCode());
        MsgToUserPojo $msgToUserPojo = this.getMsgToUserPojo();
        result = result * 59 + ($msgToUserPojo == null ? 43 : ((Object)$msgToUserPojo).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ThirdMessageDTO(userId=" + this.getUserId() + ", targetUserId=" + this.getTargetUserId() + ", templateKey=" + this.getTemplateKey() + ", content=" + this.getContent() + ", title=" + this.getTitle() + ", groupId=" + this.getGroupId() + ", type=" + this.getType() + ", roundId=" + this.getRoundId() + ", auditDetailId=" + this.getAuditDetailId() + ", mainType=" + this.getMainType() + ", msgToUserPojo=" + this.getMsgToUserPojo() + ", createTime=" + this.getCreateTime() + ")";
    }

    public ThirdMessageDTO(Integer userId, Integer targetUserId, String templateKey, ParamContext content, ParamContext title, String groupId, String type, String roundId, String auditDetailId, Integer mainType, MsgToUserPojo msgToUserPojo, Date createTime) {
        this.userId = userId;
        this.targetUserId = targetUserId;
        this.templateKey = templateKey;
        this.content = content;
        this.title = title;
        this.groupId = groupId;
        this.type = type;
        this.roundId = roundId;
        this.auditDetailId = auditDetailId;
        this.mainType = mainType;
        this.msgToUserPojo = msgToUserPojo;
        this.createTime = createTime;
    }

    public ThirdMessageDTO() {
    }

    public static class ThirdMessageDTOBuilder {
        private Integer userId;
        private Integer targetUserId;
        private String templateKey;
        private ParamContext content;
        private ParamContext title;
        private String groupId;
        private String type;
        private String roundId;
        private String auditDetailId;
        private Integer mainType;
        private MsgToUserPojo msgToUserPojo;
        private Date createTime;

        ThirdMessageDTOBuilder() {
        }

        public ThirdMessageDTOBuilder userId(Integer userId) {
            this.userId = userId;
            return this;
        }

        public ThirdMessageDTOBuilder targetUserId(Integer targetUserId) {
            this.targetUserId = targetUserId;
            return this;
        }

        public ThirdMessageDTOBuilder templateKey(String templateKey) {
            this.templateKey = templateKey;
            return this;
        }

        public ThirdMessageDTOBuilder content(ParamContext content) {
            this.content = content;
            return this;
        }

        public ThirdMessageDTOBuilder title(ParamContext title) {
            this.title = title;
            return this;
        }

        public ThirdMessageDTOBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public ThirdMessageDTOBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ThirdMessageDTOBuilder roundId(String roundId) {
            this.roundId = roundId;
            return this;
        }

        public ThirdMessageDTOBuilder auditDetailId(String auditDetailId) {
            this.auditDetailId = auditDetailId;
            return this;
        }

        public ThirdMessageDTOBuilder mainType(Integer mainType) {
            this.mainType = mainType;
            return this;
        }

        public ThirdMessageDTOBuilder msgToUserPojo(MsgToUserPojo msgToUserPojo) {
            this.msgToUserPojo = msgToUserPojo;
            return this;
        }

        public ThirdMessageDTOBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public ThirdMessageDTO build() {
            return new ThirdMessageDTO(this.userId, this.targetUserId, this.templateKey, this.content, this.title, this.groupId, this.type, this.roundId, this.auditDetailId, this.mainType, this.msgToUserPojo, this.createTime);
        }

        public String toString() {
            return "ThirdMessageDTO.ThirdMessageDTOBuilder(userId=" + this.userId + ", targetUserId=" + this.targetUserId + ", templateKey=" + this.templateKey + ", content=" + this.content + ", title=" + this.title + ", groupId=" + this.groupId + ", type=" + this.type + ", roundId=" + this.roundId + ", auditDetailId=" + this.auditDetailId + ", mainType=" + this.mainType + ", msgToUserPojo=" + this.msgToUserPojo + ", createTime=" + this.createTime + ")";
        }
    }
}

