/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;

public class DiffUtil {
    public static <T> DiffResult<T> diffList(Collection<T> baseList, Collection<T> targetList, @NotNull Function<T, Object> primaryKeyExtractor, @NotNull Comparator<T> elementComparator) {
        DiffResult<T> checkResult = DiffUtil.checkEmptyAndReturn(baseList, targetList);
        if (checkResult != null) {
            return checkResult;
        }
        HashMap<Object, T> baseMap = new HashMap<Object, T>(4096);
        for (T base : baseList) {
            Object key = primaryKeyExtractor.apply(base);
            baseMap.put(key, base);
        }
        ArrayList<T> addedList = new ArrayList<T>();
        ArrayList<T> changedList = new ArrayList<T>();
        ArrayList deletedList = new ArrayList();
        ArrayList<T> sanmeList = new ArrayList<T>();
        for (T target : targetList) {
            Object key = primaryKeyExtractor.apply(target);
            Object base = baseMap.get(key);
            if (base == null) {
                addedList.add(target);
                continue;
            }
            baseMap.remove(key);
            if (elementComparator.compare(base, target) != 0) {
                changedList.add(target);
                continue;
            }
            if (elementComparator.compare(base, target) != 0) continue;
            sanmeList.add(target);
        }
        Set entrySet = baseMap.entrySet();
        if (CollectionUtils.isNotEmpty(entrySet)) {
            for (Map.Entry entry : entrySet) {
                deletedList.add(entry.getValue());
            }
        }
        return new DiffResult<T>().setAddedList(addedList).setChangedList(changedList).setDeletedList(deletedList).setSameList(sanmeList);
    }

    private static <T> DiffResult<T> checkEmptyAndReturn(Collection<T> baseList, Collection<T> targetList) {
        if (CollectionUtils.isEmpty(baseList) && CollectionUtils.isEmpty(targetList)) {
            return new DiffResult().setAddedList(null).setChangedList(null).setDeletedList(null);
        }
        if (CollectionUtils.isEmpty(baseList) && CollectionUtils.isNotEmpty(targetList)) {
            return new DiffResult<T>().setAddedList(targetList).setChangedList(null).setDeletedList(null);
        }
        if (CollectionUtils.isNotEmpty(baseList) && CollectionUtils.isEmpty(targetList)) {
            return new DiffResult().setAddedList(null).setChangedList(null).setDeletedList(baseList);
        }
        return null;
    }

    public static interface ID {
        public Integer getId();

        public ID setId(Integer var1);
    }

    public static class DiffResult<T> {
        private Collection<T> addedList;
        private Collection<T> changedList;
        private Collection<T> deletedList;
        private Collection<T> sameList;

        public Collection<T> getAddedList() {
            return this.addedList;
        }

        public Collection<T> getChangedList() {
            return this.changedList;
        }

        public Collection<T> getDeletedList() {
            return this.deletedList;
        }

        public Collection<T> getSameList() {
            return this.sameList;
        }

        public DiffResult<T> setAddedList(Collection<T> addedList) {
            this.addedList = addedList;
            return this;
        }

        public DiffResult<T> setChangedList(Collection<T> changedList) {
            this.changedList = changedList;
            return this;
        }

        public DiffResult<T> setDeletedList(Collection<T> deletedList) {
            this.deletedList = deletedList;
            return this;
        }

        public DiffResult<T> setSameList(Collection<T> sameList) {
            this.sameList = sameList;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DiffResult)) {
                return false;
            }
            DiffResult other = (DiffResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<T> this$addedList = this.getAddedList();
            Collection<T> other$addedList = other.getAddedList();
            if (this$addedList == null ? other$addedList != null : !((Object)this$addedList).equals(other$addedList)) {
                return false;
            }
            Collection<T> this$changedList = this.getChangedList();
            Collection<T> other$changedList = other.getChangedList();
            if (this$changedList == null ? other$changedList != null : !((Object)this$changedList).equals(other$changedList)) {
                return false;
            }
            Collection<T> this$deletedList = this.getDeletedList();
            Collection<T> other$deletedList = other.getDeletedList();
            if (this$deletedList == null ? other$deletedList != null : !((Object)this$deletedList).equals(other$deletedList)) {
                return false;
            }
            Collection<T> this$sameList = this.getSameList();
            Collection<T> other$sameList = other.getSameList();
            return !(this$sameList == null ? other$sameList != null : !((Object)this$sameList).equals(other$sameList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DiffResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<T> $addedList = this.getAddedList();
            result = result * 59 + ($addedList == null ? 43 : ((Object)$addedList).hashCode());
            Collection<T> $changedList = this.getChangedList();
            result = result * 59 + ($changedList == null ? 43 : ((Object)$changedList).hashCode());
            Collection<T> $deletedList = this.getDeletedList();
            result = result * 59 + ($deletedList == null ? 43 : ((Object)$deletedList).hashCode());
            Collection<T> $sameList = this.getSameList();
            result = result * 59 + ($sameList == null ? 43 : ((Object)$sameList).hashCode());
            return result;
        }

        public String toString() {
            return "DiffUtil.DiffResult(addedList=" + this.getAddedList() + ", changedList=" + this.getChangedList() + ", deletedList=" + this.getDeletedList() + ", sameList=" + this.getSameList() + ")";
        }
    }
}

