/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String toJson(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)JSON.parseObject((String)json, clazz);
        }
        catch (Exception ex) {
            logger.error("json decode error. json:" + json + ";class:" + clazz.getName());
            return null;
        }
    }

    public static <T> T fromJsonWithJackson(String json, Class<T> clazz) {
        if (json == null || json.trim().isEmpty()) {
            throw new IllegalArgumentException("JSON string cannot be null or empty");
        }
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert JSON to object: " + e.getMessage(), e);
        }
    }

    public static String toJsonWithJackson(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert object to JSON: " + e.getMessage(), e);
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to get value of field '" + fieldName + "': " + e.getMessage(), e);
        }
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to set value of field '" + fieldName + "': " + e.getMessage(), e);
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> type) {
        try {
            return (T)JSON.parseObject((String)json, type, (Feature[])new Feature[0]);
        }
        catch (Exception ex) {
            logger.error("json decode error. json:" + json + ";type:" + type.getType().getTypeName());
            return null;
        }
    }

    public static <T> T fromJson(String json, Type type) {
        try {
            return (T)JSON.parseObject((String)json, (Type)type, (Feature[])new Feature[0]);
        }
        catch (Exception ex) {
            logger.error("json decode error. json:" + json + ";type:" + type.getTypeName());
            return null;
        }
    }

    static {
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    }
}

