/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ListUtils {
    public static <E> void sort(List<E> list, final boolean isAsc, final String ... sortnameArr) {
        Collections.sort(list, new Comparator<E>(){

            @Override
            public int compare(E a, E b) {
                int ret = 0;
                try {
                    for (int i = 0; i < sortnameArr.length && 0 == (ret = ListUtils.compareObject(sortnameArr[i], isAsc, a, b)); ++i) {
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return ret;
            }
        });
    }

    public static <E> void sort(List<E> list, final String[] sortnameArr, final boolean[] typeArr) {
        if (sortnameArr.length != typeArr.length) {
            throw new RuntimeException("\u5c5e\u6027\u6570\u7ec4\u5143\u7d20\u4e2a\u6570\u548c\u5347\u964d\u5e8f\u6570\u7ec4\u5143\u7d20\u4e2a\u6570\u4e0d\u76f8\u7b49");
        }
        Collections.sort(list, new Comparator<E>(){

            @Override
            public int compare(E a, E b) {
                int ret = 0;
                try {
                    for (int i = 0; i < sortnameArr.length && 0 == (ret = ListUtils.compareObject(sortnameArr[i], typeArr[i], a, b)); ++i) {
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return ret;
            }
        });
    }

    private static <E> int compareObject(String sortname, boolean isAsc, E a, E b) throws Exception {
        Object value1 = ListUtils.forceGetFieldValue(a, sortname);
        Object value2 = ListUtils.forceGetFieldValue(b, sortname);
        String str1 = value1.toString();
        String str2 = value2.toString();
        if (value1 instanceof Number && value2 instanceof Number) {
            int maxlen = Math.max(str1.length(), str2.length());
            str1 = ListUtils.addZero2Str((Number)value1, maxlen);
            str2 = ListUtils.addZero2Str((Number)value2, maxlen);
        } else if (value1 instanceof Date && value2 instanceof Date) {
            long time1 = ((Date)value1).getTime();
            long time2 = ((Date)value2).getTime();
            int maxlen = Long.toString(Math.max(time1, time2)).length();
            str1 = ListUtils.addZero2Str(time1, maxlen);
            str2 = ListUtils.addZero2Str(time2, maxlen);
        }
        int ret = isAsc ? str1.compareTo(str2) : str2.compareTo(str1);
        return ret;
    }

    public static String addZero2Str(Number numObj, int length) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumIntegerDigits(length);
        nf.setMinimumIntegerDigits(length);
        return nf.format(numObj);
    }

    public static Object forceGetFieldValue(Object obj, String fieldName) throws Exception {
        Field field = obj.getClass().getDeclaredField(fieldName);
        Object object = null;
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
            object = field.get(obj);
            field.setAccessible(accessible);
            return object;
        }
        object = field.get(obj);
        return object;
    }

    public static List<Integer> stringToList(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return new ArrayList<Integer>();
        }
        return Stream.of(string.split(",")).map(Integer::parseInt).distinct().collect(Collectors.toList());
    }

    public static String listToString(List<Integer> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        return list.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    public static String listStrToString(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        return list.stream().map(String::valueOf).collect(Collectors.joining(";\n"));
    }

    public static <T> List<List<T>> partition(List<T> list, int batchSize) {
        ArrayList<List<T>> partitions = new ArrayList<List<T>>();
        int totalSize = list.size();
        for (int i = 0; i < totalSize; i += batchSize) {
            partitions.add(list.subList(i, Math.min(totalSize, i + batchSize)));
        }
        return partitions;
    }

    public static boolean areCollectionsEqual(Collection<?> collection1, Collection<?> collection2) {
        return collection1.equals(collection2);
    }

    public static <T> List<List<T>> splitList(List<T> list, int len) {
        if (list == null || list.size() == 0 || len < 1) {
            return null;
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int size = list.size();
        int count = (size + len - 1) / len;
        for (int i = 0; i < count; ++i) {
            int fromIndex = i * len;
            int toIndex = Math.min((i + 1) * len, size);
            result.add(list.subList(fromIndex, toIndex));
        }
        return result;
    }
}

