/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisDelayedTaskUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisDelayedTaskUtil.class);
    private final RedisTemplate<String, Object> redisTemplate;
    private static final String DELAYED_QUEUE_KEY = "delayed_tasks_queue";
    private static final String PROCESSING_LOCK_KEY_PREFIX = "processing_lock:";
    private volatile boolean consumeEnabled = true;

    public RedisDelayedTaskUtil(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setConsumeEnabled(boolean status) {
        this.consumeEnabled = status;
        log.info("Consume control set to: {}", (Object)status);
    }

    public boolean isConsumeEnabled() {
        return this.consumeEnabled;
    }

    public void addTask(String taskKey, long triggerTime, Object taskData) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String serializedTaskData = objectMapper.writeValueAsString(taskData);
            this.redisTemplate.opsForZSet().add((Object)DELAYED_QUEUE_KEY, (Object)(taskKey + "::" + serializedTaskData), (double)triggerTime);
            log.info("Task added to delayed queue: key={}, triggerTime={}", (Object)taskKey, (Object)triggerTime);
        }
        catch (Exception e) {
            log.error("Error adding task to delayed queue: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public Set<Object> fetchReadyTasks() {
        long now = System.currentTimeMillis();
        try {
            Set readyTasks = this.redisTemplate.opsForZSet().rangeByScore((Object)DELAYED_QUEUE_KEY, 0.0, (double)now);
            if (readyTasks != null && !readyTasks.isEmpty()) {
                for (Object task : readyTasks) {
                    String lockKey = PROCESSING_LOCK_KEY_PREFIX + task;
                    log.info("Trying to acquire lock for task: {}", (Object)lockKey);
                    Boolean lockAcquired = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)"LOCKED", 10L, TimeUnit.SECONDS);
                    if (Boolean.TRUE.equals(lockAcquired)) {
                        this.redisTemplate.opsForZSet().remove((Object)DELAYED_QUEUE_KEY, new Object[]{task});
                        log.info("Task locked and removed: {}", task);
                        continue;
                    }
                    log.info("Task is being processed by another node: {}", task);
                }
            }
            return readyTasks;
        }
        catch (Exception e) {
            log.error("Error fetching ready tasks: {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptySet();
        }
    }

    public void releaseLock(Object task) {
        try {
            String lockKey = PROCESSING_LOCK_KEY_PREFIX + task;
            this.redisTemplate.delete((Object)lockKey);
            log.info("Released lock for task: {}", task);
        }
        catch (Exception e) {
            log.error("Error releasing lock for task: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

