/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger logger = LoggerFactory.getLogger(StreamUtils.class);

    public static byte[] getByteByStream(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int length = 0;
        while (length != -1) {
            try {
                length = is.read(b);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Object)logger);
            }
            if (length == -1) continue;
            baos.write(b, 0, length);
        }
        if (is != null) {
            try {
                is.close();
                is = null;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Object)logger);
            }
        }
        return baos.toByteArray();
    }

    public static String getStringByStream(InputStream is, String charset) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        String str = result.toString(charset);
        return str;
    }
}

