/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.proxy;

import com.alibaba.fastjson.JSON;
import com.ovopark.api.DepartmentApi;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.pojo.BaseResult;
import com.ovopark.pojo.DepInfoVo;
import com.ovopark.pojo.DepartmentPojo;
import com.ovopark.pojo.IdAndNameVo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DepartProxy {
    private static final Logger log = LoggerFactory.getLogger(DepartProxy.class);
    @Resource
    DepartmentApi departmentApi;

    public Map<Integer, String> getDeptNameMap(List<Integer> deptIdList) {
        BaseResult listBaseResult = this.departmentApi.queryNameOfDept(deptIdList);
        if (listBaseResult.getIsError().booleanValue()) {
            throw new SysErrorException(ResultCode.DEPARTMENT_FEIGN_ERROR, new Object[0]);
        }
        List data = (List)listBaseResult.getData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            return new HashMap<Integer, String>();
        }
        Map<Integer, String> result = data.stream().collect(Collectors.toMap(IdAndNameVo::getId, IdAndNameVo::getName));
        return result;
    }

    public DepartmentPojo getDepartment(Integer deptId) {
        BaseResult baseResult = this.departmentApi.getDepartmentById(deptId);
        if (baseResult.getIsError().booleanValue()) {
            throw new SysErrorException(ResultCode.DEPARTMENT_FEIGN_ERROR, new Object[0]);
        }
        DepartmentPojo pojo = (DepartmentPojo)baseResult.getData();
        if (pojo == null) {
            return new DepartmentPojo();
        }
        return pojo;
    }

    public Map<Integer, String> getDepartmentByGroupId(Integer groupId) {
        Map<Integer, String> map = new HashMap<Integer, String>();
        BaseResult baseResult = this.departmentApi.getDepartmentByGroupId(groupId);
        if (baseResult.getIsError().booleanValue()) {
            throw new SysErrorException(ResultCode.DEPARTMENT_FEIGN_ERROR, new Object[0]);
        }
        if (!CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            map = ((List)baseResult.getData()).stream().collect(Collectors.toMap(DepInfoVo::getId, p -> StringUtils.trim((String)p.getName())));
        }
        return map;
    }

    public Map<Integer, DepartmentPojo> getDepartments(List<Integer> deptIdList) {
        Map<Integer, Object> collect = new HashMap<Integer, DepartmentPojo>();
        log.info("\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\uff1a" + JSON.toJSONString(deptIdList));
        List pojos = (List)this.departmentApi.getDepartmentListByIdList(deptIdList).getData();
        if (CollectionUtils.isEmpty((Collection)pojos)) {
            return collect;
        }
        collect = pojos.stream().collect(Collectors.toMap(DepartmentPojo::getId, Function.identity()));
        return collect;
    }
}

