/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.constants.CommonConstants;
import com.ovopark.model.dto.InspectionPlanDto;
import com.ovopark.model.dto.InspectionTagDto;
import com.ovopark.model.enums.DefaultEnum;
import com.ovopark.model.enums.ExpandExecuteExpireEnum;
import com.ovopark.model.enums.InspectionTaskExpandStatusEnum;
import com.ovopark.model.enums.InspectionTaskStatusEnum;
import com.ovopark.model.enums.MainTypeEnum;
import com.ovopark.model.enums.OpenEnum;
import com.ovopark.model.enums.YesEnum;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.InspectionConfigReq;
import com.ovopark.model.resp.InspectionPlanDtoResp;
import com.ovopark.model.resp.InspectionPlanTagDetailResp;
import com.ovopark.model.resp.InspectionPlanTaskWebListResp;
import com.ovopark.organize.common.model.pojo.EnterpriseConfigPojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.service.ExportService;
import com.ovopark.service.InspectionConfigService;
import com.ovopark.utils.DateUtil;
import com.ovopark.utils.DateUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportServiceImpl
implements ExportService {
    @Autowired
    private EnterpriseGroupsApi enterpriseConfigApi;
    @Autowired
    private InspectionConfigService inspectionConfigService;

    @Override
    public void exportSecondWebList(HttpServletResponse response, List<InspectionPlanDtoResp> records, Users user) throws IOException {
        ArrayList<ExcelExportEntity> colList = new ArrayList<ExcelExportEntity>();
        EnterpriseConfigPojo configPojo = (EnterpriseConfigPojo)this.enterpriseConfigApi.getEnterpriseConfig(user.getGroupId()).getData();
        ExcelExportEntity colEntity = new ExcelExportEntity("\u5de1\u68c0\u95e8\u5e97", (Object)"depName");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        if (configPojo.getQuestionTag().equals(DefaultEnum.DEFAULT_TRUE.getCode())) {
            colEntity = new ExcelExportEntity("\u95ee\u9898\u6807\u7b7e", (Object)"tags");
            colEntity.setNeedMerge(true);
            colList.add(colEntity);
        }
        if (configPojo.getQuestionDes().equals(DefaultEnum.DEFAULT_TRUE.getCode())) {
            colEntity = new ExcelExportEntity("\u95ee\u9898\u63cf\u8ff0", (Object)"description");
            colEntity.setNeedMerge(true);
            colList.add(colEntity);
        }
        colEntity = new ExcelExportEntity("\u95e8\u5e97\u5b8c\u6210\u72b6\u6001", (Object)"status");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u4efb\u52a1\u6267\u884c\u603b\u65f6\u957f", (Object)"LiveSecondsTotal");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u9884\u8ba1\u5de1\u68c0\u65e5\u671f", (Object)"expectTime");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u5b9e\u9645\u5b8c\u6210\u5de1\u68c0\u65e5\u671f", (Object)"finishTime");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        if (StringUtils.isNotBlank((CharSequence)configPojo.getExpireExecute()) && Stream.of(configPojo.getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList()).contains(MainTypeEnum.INSPECTION.getCode())) {
            colEntity = new ExcelExportEntity("\u95e8\u5e97\u8fc7\u671f\u6267\u884c", (Object)"executeExpire");
            colEntity.setNeedMerge(true);
            colList.add(colEntity);
        }
        ExcelExportEntity deliColGroup = new ExcelExportEntity("", (Object)"moban");
        ArrayList<ExcelExportEntity> deliColList = new ArrayList<ExcelExportEntity>();
        deliColList.add(new ExcelExportEntity("\u5e38\u7528\u68c0\u67e5\u8868\u540d\u79f0", (Object)"templateName"));
        deliColList.add(new ExcelExportEntity("\u4efb\u52a1\u5b8c\u6210\u72b6\u6001", (Object)"templateStatus"));
        deliColList.add(new ExcelExportEntity("\u4efb\u52a1\u6267\u884c\u65f6\u957f", (Object)"liveSeconds"));
        deliColList.add(new ExcelExportEntity("\u53d1\u73b0\u95ee\u9898\u6570", (Object)"totalProblemNum"));
        deliColList.add(new ExcelExportEntity("\u672a\u89e3\u51b3\u95ee\u9898\u6570", (Object)"problemNum"));
        deliColList.add(new ExcelExportEntity("\u5df2\u8fc7\u671f\u95ee\u9898\u6570", (Object)"invalidProblemNum"));
        deliColList.add(new ExcelExportEntity("\u5de1\u5e97\u5f00\u59cb\u65f6\u95f4", (Object)"startTime"));
        deliColList.add(new ExcelExportEntity("\u5de1\u5e97\u7ed3\u675f\u65f6\u95f4", (Object)"finishTime"));
        if (StringUtils.isNotBlank((CharSequence)configPojo.getExpireExecute()) && Stream.of(configPojo.getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList()).contains(MainTypeEnum.INSPECTION.getCode())) {
            deliColList.add(new ExcelExportEntity("\u4efb\u52a1\u8fc7\u671f\u6267\u884c", (Object)"templateExecuteExpire"));
        }
        deliColList.add(new ExcelExportEntity("\u539f\u56e0", (Object)"reason"));
        deliColGroup.setList(deliColList);
        colList.add(deliColGroup);
        ArrayList list = new ArrayList();
        for (InspectionPlanDtoResp record : records) {
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            valMap.put("depName", record.getDeptName());
            valMap.put("tags", !CollectionUtils.isEmpty((Collection)record.getTags()) ? record.getTags().stream().map(InspectionTagDto::getTagName).collect(Collectors.joining(",")) : "");
            valMap.put("description", record.getDescription());
            valMap.put("status", InspectionTaskExpandStatusEnum.PASS.getCode().equals(record.getStatus()) ? InspectionTaskExpandStatusEnum.FINISH.getDesc() : InspectionTaskExpandStatusEnum.WAIT.getDesc());
            valMap.put("LiveSecondsTotal", DateUtil.secondsConvertToDateStr((int)record.getLiveSeconds()));
            valMap.put("expectTime", StringUtils.isNotBlank((CharSequence)record.getExpectTimeStr()) ? record.getExpectTimeStr() : "");
            valMap.put("finishTime", record.getFinishTime() != null ? DateUtils.format((Date)record.getFinishTime(), (String)DateUtils.FORMAT_LONG) : "");
            valMap.put("executeExpire", record.getExecuteExpire() == null ? "" : ExpandExecuteExpireEnum.formatOrNull((Integer)record.getExecuteExpire()).getDesc());
            if (CollectionUtils.isNotEmpty((Collection)record.getData())) {
                ArrayList deliDetailList = new ArrayList();
                for (InspectionPlanDto recordDatum : record.getData()) {
                    HashMap<String, Object> deliValMap = new HashMap<String, Object>();
                    deliValMap.put("templateName", recordDatum.getTemplateName());
                    deliValMap.put("templateStatus", InspectionTaskExpandStatusEnum.PASS.getCode().equals(recordDatum.getStatus()) ? InspectionTaskExpandStatusEnum.FINISH.getDesc() : InspectionTaskExpandStatusEnum.WAIT.getDesc());
                    deliValMap.put("liveSeconds", DateUtil.secondsConvertToDateStr((int)recordDatum.getLiveSeconds()));
                    deliValMap.put("totalProblemNum", recordDatum.getTotalProblemNum());
                    deliValMap.put("problemNum", recordDatum.getProblemNum());
                    deliValMap.put("invalidProblemNum", recordDatum.getInvalidProblemNum());
                    deliValMap.put("startTime", DateUtils.format((Date)recordDatum.getStartTime(), (String)DateUtils.FORMAT_LONG));
                    deliValMap.put("finishTime", DateUtils.format((Date)recordDatum.getFinishTime(), (String)DateUtils.FORMAT_LONG));
                    deliValMap.put("templateExecuteExpire", ExpandExecuteExpireEnum.formatOrNull((Integer)recordDatum.getExecuteExpire()).getDesc());
                    deliValMap.put("reason", recordDatum.getReason());
                    deliDetailList.add(deliValMap);
                }
                valMap.put("moban", deliDetailList);
            }
            list.add(valMap);
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u8be6\u60c5\u5217\u8868", "\u6570\u636e", ExcelType.HSSF), colList, list);
        this.exportReturn(response, workbook);
    }

    @Override
    public void webList(HttpServletResponse response, List<InspectionPlanTaskWebListResp> records, Users user) throws IOException {
        response.setContentType("application/binary;charset=UTF-8");
        response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode("\u5de1\u68c0\u8ba1\u5212\u62a5\u8868.xls", "utf-8"));
        InspectionConfigReq config = this.inspectionConfigService.getInspectionConfig(user);
        ArrayList<ExcelExportEntity> colList = new ArrayList<ExcelExportEntity>();
        ExcelExportEntity colEntity = new ExcelExportEntity("\u4efb\u52a1\u540d\u79f0", (Object)"NAME");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u6267\u884c\u4eba", (Object)"OPERATOR");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u5ba1\u6838\u4eba", (Object)"AUDIT");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        if (config.getQuestionTag().equals(OpenEnum.OPEN.getCode())) {
            colEntity = new ExcelExportEntity("\u95ee\u9898\u6807\u7b7e", (Object)"TAG");
            colEntity.setNeedMerge(true);
            colList.add(colEntity);
        }
        colEntity = new ExcelExportEntity("\u95e8\u5e97\u6570\u91cf", (Object)"DEPT_NUM");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u5f00\u59cb\u65f6\u95f4", (Object)"START_TIME");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u7ed3\u675f\u65f6\u95f4", (Object)"END_TIME");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u72b6\u6001", (Object)"STATUS");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u5b8c\u6210\u8fdb\u5ea6", (Object)"PERCENT");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        colEntity = new ExcelExportEntity("\u5907\u6ce8", (Object)"REMARK");
        colEntity.setNeedMerge(true);
        colList.add(colEntity);
        ArrayList list = new ArrayList();
        for (InspectionPlanTaskWebListResp record : records) {
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            valMap.put("NAME", record.getName());
            valMap.put("OPERATOR", record.getOperatorName());
            if (config.getQuestionTag().equals(OpenEnum.OPEN.getCode())) {
                ArrayList<String> tagNameList = new ArrayList<String>();
                for (InspectionPlanTagDetailResp inspectionPlanTagDetailResp : record.getTagList()) {
                    tagNameList.add(inspectionPlanTagDetailResp.getTagName());
                }
                valMap.put("TAG", StringUtils.join(tagNameList, (String)","));
            }
            valMap.put("DEPT_NUM", record.getDeptNum());
            valMap.put("START_TIME", record.getStartTimeStr());
            valMap.put("END_TIME", record.getEndTimeStr());
            valMap.put("AUDIT", record.getAuditName());
            if (record.getExpireStatus().equals(YesEnum.DELETED.getCode())) {
                valMap.put("STATUS", InspectionTaskStatusEnum.EXPIRE.getDesc());
            } else {
                valMap.put("STATUS", InspectionTaskStatusEnum.format((Integer)record.getStatus()) == null ? "" : InspectionTaskStatusEnum.format((Integer)record.getStatus()).getDesc());
            }
            valMap.put("PERCENT", record.getCompletePercent());
            valMap.put("REMARK", record.getRemark());
            list.add(valMap);
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(CommonConstants.TASK_EXCEL_FILE_NAME, "\u6570\u636e"), colList, list);
        this.exportReturn(response, workbook);
    }

    private void exportReturn(HttpServletResponse response, Workbook workbook) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        workbook.write((OutputStream)outputStream);
        outputStream.flush();
        workbook.close();
    }
}

