/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.ovopark.mapper.InspectionCategoryMapper;
import com.ovopark.mapper.InspectionTagMapper;
import com.ovopark.model.base.EntityBase;
import com.ovopark.model.dto.InspectionTagDto;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.InspectionTagAddReq;
import com.ovopark.model.req.InspectionTagDeleteReq;
import com.ovopark.model.req.InspectionTagListReq;
import com.ovopark.model.req.InspectionTagUpdateReq;
import com.ovopark.model.resp.InspectionTagCategoryListResp;
import com.ovopark.model.resp.InspectionTagListResp;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.po.InspectionCategory;
import com.ovopark.po.InspectionTag;
import com.ovopark.service.InspectionTagService;
import com.ovopark.utils.ClazzConverterUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InspectionTagServiceImpl
extends ServiceImpl<InspectionTagMapper, InspectionTag>
implements InspectionTagService {
    @Autowired
    InspectionTagMapper inspectionTagMapper;
    @Autowired
    InspectionCategoryMapper inspectionCategoryMapper;

    @Override
    public JsonNewResult<Void> add(InspectionTagAddReq req, Users user) {
        InspectionTag tag = new InspectionTag(req.getGroupId(), req.getCategoryId(), req.getName());
        EntityBase.setCreateParams((Object)tag, (Users)user);
        this.inspectionTagMapper.insertSelective(tag);
        return JsonNewResult.success();
    }

    @Override
    public JsonNewResult<Void> update(InspectionTagUpdateReq req, Users user) {
        InspectionTag tag = new InspectionTag(req.getId(), req.getGroupId(), req.getCategoryId(), req.getName());
        EntityBase.setUpdateParams((Object)tag, (Users)user);
        int isOk = this.inspectionTagMapper.updateByPrimaryId(tag);
        return JsonNewResult.success();
    }

    @Override
    public JsonNewResult<Void> delete(InspectionTagDeleteReq req, Users user) {
        int isOk = this.inspectionTagMapper.deleteByPrimaryId(req.getId());
        return JsonNewResult.success();
    }

    @Override
    public JsonNewResult<List<InspectionTagCategoryListResp>> list(InspectionTagListReq req, Users user) {
        Integer groupId = user.getGroupId();
        List categoryList = this.inspectionCategoryMapper.selectCategoryListByGroupId(groupId);
        if (CollectionUtils.isEmpty((Collection)categoryList)) {
            return JsonNewResult.success(new ArrayList());
        }
        List categoryIdList = categoryList.stream().map(InspectionCategory::getId).collect(Collectors.toList());
        List tagList = this.inspectionTagMapper.selectTagListByCategoryIdList(categoryIdList, groupId);
        List result = ClazzConverterUtils.converterClass((Collection)categoryList, InspectionTagCategoryListResp.class);
        if (CollectionUtils.isEmpty((Collection)tagList)) {
            return JsonNewResult.success((Object)result);
        }
        List tagRespList = ClazzConverterUtils.converterClass((Collection)tagList, InspectionTagListResp.class);
        Map<Integer, List> categoryMapTagListMapping = tagRespList.stream().collect(Collectors.toMap(InspectionTagListResp::getCategoryId, xva$0 -> Lists.newArrayList((Object[])new InspectionTagListResp[]{xva$0}), (oldValue, newValue) -> {
            oldValue.addAll(newValue);
            return oldValue;
        }));
        for (InspectionTagCategoryListResp categoryListResp : result) {
            categoryListResp.setTags(categoryMapTagListMapping.get(categoryListResp.getId()));
        }
        return JsonNewResult.success((Object)result);
    }

    @Override
    public Map<Integer, String> getNameMapByTaskIds(List<Integer> taskIds, Integer groupId) {
        Map<Integer, String> map = new HashMap<Integer, String>();
        List tagDtos = this.inspectionTagMapper.getNameMapByTaskIds(groupId, taskIds);
        if (!CollectionUtils.isEmpty((Collection)tagDtos)) {
            map = tagDtos.stream().collect(Collectors.groupingBy(InspectionTagDto::getTaskId, Collectors.mapping(InspectionTagDto::getTagName, Collectors.joining(","))));
        }
        return map;
    }
}

