/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.ovopark.model.login.Users;
import com.ovopark.model.req.InspectionConfigReq;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.EnterpriseConfigPojo;
import com.ovopark.organize.common.model.pojo.EnterpriseConfigSavePojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.service.InspectionConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionConfigServiceImpl
implements InspectionConfigService {
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;
    @Autowired
    private StringRedisTemplate lockRedisTemplate;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveInspectionConfig(Users user, InspectionConfigReq req) {
        EnterpriseConfigSavePojo pojo = new EnterpriseConfigSavePojo();
        pojo.setId(req.getId());
        pojo.setGroupId(user.getGroupId());
        pojo.setAddCopy(req.getAddCopy());
        pojo.setDepChose(req.getDepChose());
        pojo.setQuestionTag(req.getQuestionTag());
        pojo.setQuestionDes(req.getQuestionDes());
        this.enterpriseGroupsApi.saveEnterpriseConfigPojo(pojo);
        String redis = "ORGANIZE_ENTERPRISE_CONFIG_" + user.getGroupId();
        this.lockRedisTemplate.delete((Object)redis);
    }

    @Override
    public InspectionConfigReq getInspectionConfig(Users user) {
        BaseResult result = this.enterpriseGroupsApi.getEnterpriseConfig(user.getGroupId());
        InspectionConfigReq req = new InspectionConfigReq();
        if (result.getData() != null) {
            req.setId(((EnterpriseConfigPojo)result.getData()).getId());
            req.setDepChose(((EnterpriseConfigPojo)result.getData()).getDepChose());
            req.setAddCopy(((EnterpriseConfigPojo)result.getData()).getAddCopy());
            req.setQuestionTag(((EnterpriseConfigPojo)result.getData()).getQuestionTag());
            req.setQuestionDes(((EnterpriseConfigPojo)result.getData()).getQuestionDes());
        }
        return req;
    }
}

